from .arcadia import arcadia_binary  # noqa
from .dummy import dummy_task as dummy  # noqa
from .portoshell import portoshell_slow  # noqa
from .shell import shell_task as shell  # noqa

from .egg import execute_egg as _execute_egg
from .common import Wrapper as _Wrapper, PidIteratorWrapper as _PidIteratorWrapper


def _find_function(task, on_spawn, on_ready):
    fn_name = task['options'].get('exec_fn', None)
    if fn_name and not fn_name.startswith('_'):
        it = _PidIteratorWrapper(None)
        custom_fn = _Wrapper(globals()[fn_name], on_ready)
        it.set_object(custom_fn(task))
        on_spawn()
        return it
    else:
        return _execute_egg(task, on_spawn, on_ready)
