import sys
import types

from .common import PidIteratorWrapper, Wrapper

from ... import msgpackutils as msgpack
from ...importer import InMemoryImporter
from ...utils import singleton, log as root

from ya.skynet.util import pickle


def execute_egg(task, on_import, on_ready):
    pickled = task['data']
    pickled_arg = task['options'].get('exec_extra_params')

    obj, egg_content = msgpack.loads(pickled)

    try:
        importer = InMemoryImporter(egg_content)

        prefixesForDelete = set()
        for name in list(sys.modules.keys()):
            if (
                name != __name__
                and name in importer.modnames
            ):
                log().debug("unloading {}".format(name))
                sys.modules.pop(name, None)
                prefixesForDelete.add(name + '.')

        for name in list(sys.modules.keys()):
            for prefix in prefixesForDelete:
                if (
                    name.startswith(prefix)
                    and 'cqudp' not in name
                ):
                    log().debug("unloading {}".format(name))
                    sys.modules.pop(name, None)
                    break

        sys.meta_path.append(importer)

        if "__new__main__" in sys.modules:
            del sys.modules["__new__main__"]

        on_import()

        oldMain = sys.modules.pop("__main__", None)  # noqa

    except Exception as err:
        log().exception(err, exc_info=sys.exc_info())
        raise

    try:
        sys.modules["__main__"] = MainWrapper()

        it = PidIteratorWrapper(None)
        obj = Wrapper(pickle.loads(obj))
        on_ready()

        if pickled_arg is not None:
            it.set_object(obj(pickle.loads(pickled_arg)))
        else:
            it.set_object(obj())
        return it

    except Exception as err:
        log().exception(err, exc_info=sys.exc_info())
        raise


class MainWrapper(types.ModuleType):
    """
    Wrapper around main module which loads it on demand
    """

    def __init__(self):
        types.ModuleType.__init__(self, '__main__')
        object.__setattr__(self, 'new_main', None)
        object.__setattr__(self, '__builtins__', __builtins__)  # workaround for apsw

    def replace_main(self):
        """
        Performs replacement of __main__ with __new__main__
        """
        if self.new_main:
            return

        # noinspection PyUnresolvedReferences
        import __new__main__

        sys.modules["__main__"] = __new__main__
        object.__setattr__(self, 'new_main', __new__main__)

    def __getattr__(self, key):
        self.replace_main()
        return getattr(self.new_main, key)

    def __setattr__(self, key, value):
        self.replace_main()
        setattr(self.new_main, key, value)

    def __delattr__(self, item):
        self.replace_main()
        delattr(self.new_main, item)


@singleton
def log():
    return root().getChild('exec_functions.egg')
