import time
import errno
import random
import select
import socket

from ... import msgpackutils as msgpack

from ya.skynet.library.portoshell import establish_connection
from ya.skynet.util.net.socketstream import SocketStream


def portoshell_slow(task, on_ready):
    on_ready()
    init_msg = task['data']
    # stream = task['options']['exec_args'].get('stream', False)  # TODO

    smooth = task['options']['exec_args'].get('smooth')
    if smooth:
        time.sleep(random.randint(0, int(smooth)))

    try:
        conn = establish_connection('localhost', 10045, init_msg)
    except Exception as e:
        raise RuntimeError("Portoshell is not available on this host: %s" % (e,))

    fd = conn.fileno()
    stream = msgpack.Unpacker(use_list=True)

    while True:
        try:
            r_fds, _, _ = select.select([fd], [], [], 3.0)
            if fd in r_fds:
                # FIXME remove StreamBase and take MsgpackStream from cqueue
                buf = SocketStream(conn).readBEStr()
                stream.feed(buf)
                for obj in stream:
                    if obj.get('error', False):
                        raise Exception(obj['message'])
                    else:
                        yield (obj['output'], obj['data'])
        except select.error as e:
            if e.args[0] != errno.EINTR:
                raise
        except socket.error as e:
            if e.errno == errno.ECONNRESET:
                break
            else:
                raise
