from __future__ import absolute_import

import os
import signal
import SocketServer

from ..utils import log as root

from ya.skynet.util.functional import singleton
from ya.skynet.util.sys.getpeerid import getpeerid


class RootControls(SocketServer.ThreadingUnixStreamServer):
    allow_reuse_address = 1

    def __init__(self, path):
        SocketServer.ThreadingUnixStreamServer.__init__(self, path, RootHandler)


class RootHandler(SocketServer.StreamRequestHandler):
    timeout = 15.0
    rbufsize = 0

    def handle(self):
        peer = getpeerid(self.connection)[0]
        request = self.rfile.readline(64).strip()
        if peer != 0:
            log().info('uid %s wanted %r, failed', peer, request)
            self.wfile.write("FAIL: not root")
            return

        method = getattr(self, 'do_' + request, None)
        if not method:
            log().info("%r requested, what's this?", request)
            self.wfile.write("FAIL: unknown method %r" % (request,))
            return

        log().info("%r requested, executing...", request)
        method()

    def do_shutdown(self):
        self.wfile.write("OK")
        self.wfile.flush()
        os.kill(os.getpid(), signal.SIGINT)


@singleton
def log():
    return root().getChild('rc')
