PY23_LIBRARY()

LICENSE(Unknown)

OWNER(torkve)

PEERDIR(
    skynet/kernel
    skynet/library
    skynet/library/auth
    skynet/api/copier
    skynet/api/heartbeat
    contrib/python/pycrypto
    contrib/python/setuptools
    library/python/nstools
)

IF(LINUX)
    PEERDIR(
        infra/porto/api_py
    )
ENDIF()

PY_SRCS(
    NAMESPACE ya.skynet.services.cqudp
    client/client.py
    client/cqueue.py
    client/daemon.py
    client/handle.py
    client/__init__.py
    client/metrics.py
    client/poll.py
    client/schedule.py
    client/session.py
    client/task.py
    client/unpickling.py
    daemon_client/__init__.py
    debugtools/buscheck.py
    debugtools/debugclient.py
    debugtools/__init__.py
    debugtools/reverse.py
    debugtools/stats.py
    eggs/collect.py
    eggs/compiled_file.py
    eggs/__init__.py
    eggs/retrieve.py
    eggs/write.py
    compat.py
    envelope.py
    exceptions.py
    importer.py
    __init__.py
    main.py
    mocksoul_rpc/client.py
    mocksoul_rpc/errors.py
    mocksoul_rpc/gevent_client.py
    mocksoul_rpc/__init__.py
    mocksoul_rpc/server.py
    mocksoul_rpc/socket.py
    mocksoul_rpc/utils.py
    msgpackutils.py
    poll.py
    rpc/__init__.py
    rpc/loghandler.py
    rpc/pipe.py
    rpc/sessionauth.py
    scripts/check.py
    scripts/common.py
    scripts/start.py
    scripts/stop.py
    server/auth.py
    server/binaryprocess.py
    server/debugmanager.py
    server/exec_functions/arcadia.py
    server/exec_functions/common.py
    server/exec_functions/dummy.py
    server/exec_functions/egg.py
    server/exec_functions/__init__.py
    server/exec_functions/portoshell.py
    server/exec_functions/shell.py
    server/executer/base.py
    server/executer/__init__.py
    server/executer/porto.py
    server/executer/procman.py
    server/executer/subprocess.py
    server/__init__.py
    server/manager.py
    server/ping.py
    server/processhandle.py
    server/root_controls.py
    server/rootwrapper.py
    server/server_main.py
    server/taskhandle.py
    server/task_main.py
    server/taskmgr.py
    server/watcher.py
    transport/envelope.py
    transport/__init__.py
    transport/messagebus.py
    transport/protocol.py
    utils.py
    window.py
)

RESOURCE_FILES(
    PREFIX infra/cqudp/src/
    .dist-info/METADATA
    .dist-info/top_level.txt
    .dist-info/namespace_packages.txt
    etc/ya.skynet.cgroups.yaml
    etc/ya.skynet.cq_containers.yaml
    etc/ya.skynet.cqudp.yaml
)

NO_CHECK_IMPORTS()

END()
