import collections

import yp.data_model as data_model


ClusterCfg = collections.namedtuple('ClusterCfg',
                                    ['name', 'address'])

XDC = ClusterCfg('xdc', 'xdc.yp.yandex.net:8090')
SAS = ClusterCfg('sas', 'sas.yp.yandex.net:8090')
MAN = ClusterCfg('man', 'man.yp.yandex.net:8090')
VLA = ClusterCfg('vla', 'vla.yp.yandex.net:8090')
IVA = ClusterCfg('iva', 'iva.yp.yandex.net:8090')
MYT = ClusterCfg('myt', 'myt.yp.yandex.net:8090')
SAS_TEST = ClusterCfg('sas-test', 'sas-test.yp.yandex.net:8090')
MAN_PRE = ClusterCfg('man-pre', 'man-pre.yp.yandex.net:8090')

CLUSTER_CONFIGS = {
    XDC.name: XDC,
    SAS.name: SAS,
    MAN.name: MAN,
    VLA.name: VLA,
    IVA.name: IVA,
    MYT.name: MYT,
    SAS_TEST.name: SAS_TEST,
    MAN_PRE.name: MAN_PRE
}

DEFAULT_CONFIG_PATH = '~/.dctl/dctl.cfg'
FORMATS = ['pb', 'yaml']
DEFAULT_FORMAT = 'yaml'
DEFAULT_FETCH_CHUNK_SIZE = 100

CLUSTERS = list(CLUSTER_CONFIGS.keys())

PRODUCTION_CLUSTERS = [
    SAS.name,
    MAN.name,
    VLA.name,
    IVA.name,
    MYT.name,
]
PRESTABLE_CLUSTERS = [MAN_PRE.name]
DEV_CLUSTERS = [
    SAS_TEST.name,
    MAN_PRE.name
]

XDC_CLUSTERS = [
    XDC.name,
    SAS_TEST.name,
    MAN_PRE.name
]
XDC_PRODUCTION_CLUSTER = XDC.name

YD_URLS_BY_XDC_CLUSTERS = {
    XDC.name: 'https://yd.yandex-team.ru',
    SAS_TEST.name: 'https://test.deploy.yandex-team.ru',
    MAN_PRE.name: 'https://man-pre.deploy.yandex-team.ru',
}

WATCH_TIME_INTERVAL = 5  # Seconds

COMMAND_ALIASES = {
    'deploy_ticket': ['ticket', 'dt'],
    'dynamic_resource': ['dr'],
    'endpoint': ['ep'],
    'endpoint_set': ['es', 'eps', 'endpoint-set'],
    'horizontal_pod_autoscaler': ['hpa'],
    'multi_cluster_replica_set': ['mcrs'],
    'pod_set': ['ps', 'pod-set'],
    'release_rule': ['rr'],
    'replica_set': ['rs', 'replica-set'],
    'stage_draft': ['draft'],
}

DCTL_CLIENT_ID = '688c92864835447b9ed74221f44420b7'
DCTL_CLIENT_SECRET = '17bb18beacef42868f023d93d475e127'

QNOTIFIER_CLIENT_ID = 'ee80fd7085d7436bba9f18bf71253c45'

YP_TOKEN_ENV = 'DCTL_YP_TOKEN'

YP_TVM_CLIENT_ID = '2001151'
YP_TVM_CLIENT_ID_PRODUCTION = '2001151'
YP_TVM_CLIENT_ID_PRESTABLE = '2024345'
YP_TVM_CLIENT_ID_DEV = '2024345'
VAULT_HOST = 'https://vault-api.passport.yandex.net'

MAX_STAGE_ID_LENGTH = 70
MAX_DEPLOY_UNIT_ID_LENGTH = 70
MAX_PROJECT_ID_LENGTH = 70

VERSION_RELEASE_ID = '__BUILD_DCTL_ACTUAL__'
VERSION_CACHE_PATH = '~/.dctl/version'
VERSION_CACHE_TTL = 86400
OUTDATED_VERSION_MESSAGE = (
    'WARNING! Current dctl version is outdated. Please update dctl to the last version '
    'using this instruction https://deploy.yandex-team.ru/docs/reference/tools/dctl#update'
)
SVN_REVISION_LABEL_NAME = 'svn_revision'


object_classes = {
    data_model.OT_POD: data_model.TPod,
    data_model.OT_POD_SET: data_model.TPodSet,
    data_model.OT_REPLICA_SET: data_model.TReplicaSet,
    data_model.OT_STAGE: data_model.TStage,
    data_model.OT_STAGE_DRAFT: data_model.TStageDraft,
    data_model.OT_MULTI_CLUSTER_REPLICA_SET: data_model.TMultiClusterReplicaSet,
    data_model.OT_ENDPOINT_SET: data_model.TEndpointSet,
    data_model.OT_ENDPOINT: data_model.TEndpoint,
    data_model.OT_DYNAMIC_RESOURCE: data_model.TDynamicResource,
    data_model.OT_RESOURCE_CACHE: data_model.TResourceCache,
    data_model.OT_DEPLOY_TICKET: data_model.TDeployTicket,
    data_model.OT_RELEASE: data_model.TRelease,
    data_model.OT_RELEASE_RULE: data_model.TReleaseRule,
    data_model.OT_APPROVAL_POLICY: data_model.TApprovalPolicy,
    data_model.OT_NOTIFICATION_POLICY: data_model.TNotificationPolicy,
    data_model.OT_HORIZONTAL_POD_AUTOSCALER: data_model.THorizontalPodAutoscaler,
    data_model.OT_PROJECT: data_model.TProject,
    data_model.OT_GROUP: data_model.TGroup,
}
