import prettytable

import yt_yson_bindings
from yp import data_model
from yt import yson


def put(ap, client):
    obj_type = data_model.OT_APPROVAL_POLICY
    obj = client.get(object_type=obj_type, object_id=ap.meta.id, ignore_nonexistent=True)
    if obj is None:
        return client.create(object_type=obj_type, obj=ap)
    else:
        client.update(object_type=obj_type, object_id=ap.meta.id, obj=ap)
        return ap.meta.id


def remove(approval_policy_id, client):
    return client.remove(
        object_type=data_model.OT_APPROVAL_POLICY,
        object_id=approval_policy_id,
    )


def cast_yaml_dict_to_yp_object(d):
    return yt_yson_bindings.loads_proto(yson.dumps(d),
                                        proto_class=data_model.TApprovalPolicy,
                                        skip_unknown_fields=False)


def list_objects(
        client,
        user,
        stage,
        limit,
):
    query_pieces = []
    if stage:
        query_pieces.append('[/meta/stage_id] = "%s"' % (stage,))

    query = ' AND '.join(query_pieces) or None

    table = prettytable.PrettyTable(['ID', 'Stage', 'Mode', 'MandatoryApproves', 'ApprovalsCount'])

    for ap in client.list(
            object_type=data_model.OT_APPROVAL_POLICY,
            user=user,
            limit=limit,
            query=query,
    ):
        try:
            mode = data_model.TApprovalPolicySpec.EMode.Name(ap.spec.mode)
        except ValueError:
            mode = 'Unknown'

        if ap.spec.WhichOneof("policy") == "multiple_approval":
            mandatory_approves = False
            approvals_count = ap.spec.multiple_approval.approvals_count
        else:
            mandatory_approves = True
            approvals_count = ap.spec.mandatory_multiple_approval.approvals_count

        table.add_row([
            ap.meta.id,
            ap.meta.stage_id,
            mode,
            mandatory_approves,
            approvals_count,
        ])

    return table
