import re

import click
import click.core
import click.parser
import click.exceptions


CYRILLIC_OPTION = re.compile('[а-яА-ЯёЁ]')


class CyrillicOptionError(click.exceptions.NoSuchOption):
    def __init__(self, option_name, possibilities=None, ctx=None):
        super(CyrillicOptionError, self).__init__(
            option_name=option_name,
            message='no such option (you use cyrillic keyboard layout): %s' % (option_name,),
            possibilities=possibilities,
            ctx=ctx,
        )


class OptionParser(click.parser.OptionParser):
    def _process_args_for_options(self, state):
        try:
            return super(OptionParser, self)._process_args_for_options(state)
        except click.exceptions.NoSuchOption as e:
            if CYRILLIC_OPTION.search(e.option_name) is not None:
                raise CyrillicOptionError(e.option_name, e.possibilities, e.ctx)
            raise


def patch_click():
    click.OptionParser = click.core.OptionParser = click.parser.OptionParser = OptionParser
