import logging

import prettytable


log = logging.getLogger('dctl')


def list_objects(clients, endpoint_set_id, limit):
    """
    :type clients: dict[unicode, infra.dctl.src.lib.yp_client.YpClient]
    :type endpoint_set_id: unicode
    :rtype: prettytable.PrettyTable
    """
    rv = prettytable.PrettyTable(['Cluster', 'ID', 'FQDN', 'IPv6', 'port', 'IPv4', 'ready'])
    for c, client in clients.items():
        batch = client.list_endpoints(endpoint_set_id, limit)
        for e in batch:
            rv.add_row([c, e.meta.id, e.spec.fqdn, e.spec.ip6_address, e.spec.port, e.spec.ip4_address, e.status.ready])
    return rv
