import logging

import prettytable
import yt.yson as yson
import yt_yson_bindings
import yp.data_model as data_model

log = logging.getLogger('dctl')


def get(es_id, client):
    """
    :type es_id: str
    :type client: infra.dctl.src.lib.yp_client.YpClient
    :rtype: yp.data_model.TEndpointSet
    """
    return client.get(object_type=data_model.OT_ENDPOINT_SET,
                      object_id=es_id)


def put(es, client):
    """
    :type es: yp.data_model.TEndpointSet
    :type client: infra.dctl.src.lib.yp_client.YpClient
    :rtype: str
    """
    obj_type = data_model.OT_ENDPOINT_SET
    obj = client.get(object_type=obj_type, object_id=es.meta.id, ignore_nonexistent=True)
    if obj is None:
        es = client.create(object_type=obj_type, obj=es)
    else:
        client.update(object_type=obj_type, object_id=es.meta.id, obj=es)
    return es.meta.id


def remove(rs_id, client):
    """
    :type rs_id: str
    :type client: infra.dctl.src.lib.yp_client.YpClient
    :rtype: yp_proto.yp.client.api.proto.object_service_pb2.TRspRemoveObject
    """
    return client.remove(object_type=data_model.OT_ENDPOINT_SET,
                         object_id=rs_id)


def list_objects(clients, user, limit):
    """
    :type user: str
    :type clients: dict[unicode, infra.dctl.src.lib.yp_client.YpClient]
    :rtype: prettytable.PrettyTable
    """
    rv = prettytable.PrettyTable(['Cluster', 'ID'])
    for cluster, client in clients.items():
        batch = client.list(data_model.OT_ENDPOINT_SET, user, limit=limit)
        for es in batch:
            rv.add_row([cluster, es.meta.id])
    return rv


def cast_yaml_dict_to_yp_object(d):
    """
    :type d: dict
    :rtype: yp.data_model.TEndpointSet
    """
    return yt_yson_bindings.loads_proto(yson.dumps(d),
                                        proto_class=data_model.TEndpointSet,
                                        skip_unknown_fields=False)
