import prettytable

import yt.yson as yson
import yt_yson_bindings
import yp.data_model as data_model


def get_pod_set(pod_set_id, client):
    """
    :type pod_set_id: str
    :type client: infra.dctl.src.lib.yp_client.YpClient
    :rtype: yp.data_model.TPodSet
    """
    return client.get(object_type=data_model.OT_POD_SET,
                      object_id=pod_set_id)


def remove_pod_set(pod_set_id, client):
    """
    :type pod_set_id: str
    :type client: infra.dctl.src.lib.yp_client.YpClient
    :rtype: yp_proto.yp.client.api.proto.object_service_pb2.TRspRemoveObject
    """
    return client.remove(object_type=data_model.OT_POD_SET,
                         object_id=pod_set_id)


def list_objects(clients, user, limit):
    """
    :type clients: dict[unicode, infra.dctl.src.lib.yp_client.YpClient]
    :type user: str
    :rtype: prettytable.PrettyTable
    """
    rv = prettytable.PrettyTable(['Cluster', 'ID', 'Node Segment'])
    for cluster, client in clients.items():
        batch = client.list(data_model.OT_POD_SET, user, limit=limit)
        for ps in batch:
            rv.add_row([cluster, ps.meta.id, ps.spec.node_segment_id])
    return rv


def cast_yaml_dict_to_yp_object(d):
    """
    :type d: dict
    :rtype: yp.data_model.TReplicaSet
    """
    return yt_yson_bindings.loads_proto(yson.dumps(d),
                                        proto_class=data_model.TPodSet,
                                        skip_unknown_fields=False)
