import yt.yson as yson


def set_label(labels, key, value):
    """
    :type labels: yp.data_model.TAttributeDictionary
    :type key: unicode
    :type value: unicode
    """
    attr = None
    for a in labels.attributes:
        if a.key == key:
            attr = a
            break
    if attr is None:
        attr = labels.attributes.add()
        attr.key = key
    attr.value = yson.dumps(value)


def get_label(labels, key, default=None):
    """
    :type labels: yp.data_model.TAttributeDictionary
    :type key: unicode
    :type default: unicode | None
    :rtype: unicode | None
    """
    for a in labels.attributes:
        if a.key == key:
            return yson.loads(a.value)
    return default
