#pragma once

#include <library/cpp/ipv6_address/ipv6_address.h>
#include <library/cpp/uri/uri.h>

#include <util/generic/singleton.h>
#include <util/datetime/base.h>

namespace NDecaPinger {
    class TConfig {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        ~TConfig();

        inline static TConfig& Get() {
            return *Singleton<TConfig>();
        }

        void Load(const TString& fileName);

        const NUri::TUri& GetProbesUri() const noexcept;
        const TDuration& GetProbesRefreshInterval() const noexcept;
        const TDuration& GetProbesResendInterval() const noexcept;
        const TDuration& GetProbesJitterInterval() const noexcept;
        const TIpv6Address& GetProbesSourceIPv4() const noexcept;
        unsigned int GetProbesSourceIPv4PrefixLen() const noexcept;
        ui16 GetProbesDestinationPort() const noexcept;

        void Out(IOutputStream& stream) const;

    private:
        TConfig();

        class TImpl;
        THolder<TImpl> Impl;
    };
}
