#pragma once

#include <infra/decapinger/src/probe.h>

#include <util/generic/singleton.h>
#include <util/generic/ptr.h>

namespace NDecaPinger {
    class TNocClient {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        ~TNocClient();

        inline static TNocClient& Get() {
            return *Singleton<TNocClient>();
        }

        const TVector<TProbe>& GetProbes() const;

    private:
        TNocClient();

        class TImpl;
        THolder<TImpl> Impl;
    };
}
