#pragma once

#include <library/cpp/ipv6_address/ipv6_address.h>

namespace NDecaPinger {
    class TPacket {
    public:
        void Send(const TIpv6Address& destination, ui16 port);

    protected:
        TPacket(std::size_t size);

        virtual SOCKET CreateSocket() = 0;

        std::size_t Size;
        enum { BufferSize = 1024 };
        static ui8 Buffer[BufferSize];
    };

    class TIPv6Packet: public TPacket {
    public:
        TIPv6Packet(const TString& payload);

    private:
        SOCKET CreateSocket() override;
    };

    class TIPv4IPv6Packet: public TPacket {
    public:
        TIPv4IPv6Packet(const TString& payload, const TIpv6Address& sourceIPv4, const TIpv6Address& destinationIPv4);

    private:
        SOCKET CreateSocket() override;
    };
}
