#pragma once

#include <library/cpp/ipv6_address/ipv6_address.h>
#include <library/cpp/json/json_value.h>

namespace NDecaPinger {
    class TProbe {
    public:
        class TDestination {
        public:
            TDestination(const TIpv6Address& innerIPv4, const TIpv6Address& nativeIPv6);

        private:
            friend class TProbe;

            TIpv6Address InnerIPv4;
            TIpv6Address NativeIPv6;
        };

        TProbe(const TString& name, const TIpv6Address& anycastIPv6);

        void AddDestination(const TIpv6Address& innerIPv4, const TIpv6Address& nativeIPv6);

        void Send() const;

        void Out(IOutputStream& stream) const;

    private:
        TString GeneratePayload() const;

        TString Name;
        TIpv6Address AnycastIPv6;
        TVector<TDestination> Destinations;

        mutable NJson::TJsonValue Payload;
    };
}
