# Примитив деплоя

Это способ управления набором Pod в Deploy Unit.

## Примитивы {#primitives}

* **Per Cluster** — Набор Pod управляется отдельно для каждой локации.
* **Multi Cluster** — Набор Pod управляется одновременно для всех локаций.

При управлении набором Pod применяется параметр **Disruption budget**, определяющий количество Pod, которые могут быть одновременно недоступны при обновлении или неисправности.

Выбор примитива деплоя зависит от нужд сервиса.

## Рекомендации для Multi Cluster {#multi-cluster}

Multi Cluster можно выбрать в том случае, если для сервиса неважно, в каких локациях есть работоспособные Pod, а значение имеет только их общее количество.

Например, предположим, что у сервиса есть несколько локаций с одним Pod в каждом. Если для Deploy Unit выбрать примитив **Per Cluster** с `Dusruption budget = 1`, то безопасно обновить Pod в локациях не получится. Есть риск, что на время деплоя производительность сервиса сильно снизится или он будет полностью недоступен. Применяя Multi Cluster для такой конфигурации вы сможете снизить риски.

## Disruption budget {#disruption-budget}

Эта настройка определяет количество Pod, которые могут быть недоступны, например, из-за [переноса между хостами](../../reference/internals/architecture/rsc.md#eviction) или при выкладке нового релиза. Выход за пределы `Disruption budget` рассматривается как внештатная ситуация, которая может быть связана с аварией, ошибкой в сервисе и т.п. В данном случае, независимо от типа, контроллер будет пытаться восстановить заданное количество подов, со стороны пользователя необходимо проверить логи приложения и отвечает ли оно на [liveness\readiness пробы](https://deploy.yandex-team.ru/docs/concepts/pod/workload/probes)

Примеры для разных примитивов деплоя:

* **Per Cluster**
Предположим, вы используете Per Cluster в локациях SAS, MAN, VLA. В каждой из локаций вы создали по 10 Pod и установили `Disruption buget = 3` для каждой локации. Это значит, что у вас одновременно могут оказаться недоступно 9 Pod из 30 (по 3 в каждой из локаций).

* **Per Cluster** с [Полокационной выкладкой](../perlocation.md)
Отличие от варианта БЕЗ **Полокационной выкладки** - более гранулярная выкладка соответственно с наименьшим количеством одновременно недоступных **Pod**. Позволяет выкатывать в заданном порядке полокационно, с возможностью подтверждения последующей выкладки. Из предыдущего примера, имеем три локации SAS, MAN, VLA с 10 подами на локацию и `Disruption buget = 3`, с выключенным подтверждением, готовность локации SAS наступит при количестве подов `10 - (Disruption buget = 3) = 7`, и покатится следующая локация MAN с аналогичным сценарием, одновременно могут быть недоступны `2x Disruption buget`. Ручное подтверждение позволяет снизить количество недоступных подов до равного `Disruption buget`.
Данный вариант подходит тем, кому нужен Per Cluster, но архитектура или нагрузка на сервис не позволяет тушить `3x Disruption buget` подов одновременно. Так же рекомендовано для выкатки опасных релизов.

* **Multi Cluster**
Предположим, вы используете Multi Cluster в локациях SAS, MAN, VLA. В каждой из локаций вы создали по 10 Pod и установили `Disruption buget = 3`. Это значит, что у вас одновременно могут оказаться недоступно только 3 Pod из 30 (не более 3 во всех локациях).

Для примитива Multi Cluster `Disruption budget` желательно установить больше, чем максимальное количество Pod в одной локации. В этом случае при полном отключении одной из локаций вы сохраните возможность автоматизированного деплоя Pod в других локациях.

Большое значение `Disruption budget` ускоряет деплой новых релизов, поскольку новые версии могут раскатываться одновременно на большое количество Pod.

## Ограничения {#limits}

Выбрать примитив деплоя можно только для нового Deploy Unit. В существующем Deploy Unit нельзя изменить примитив деплоя.

## Смотрите также {#seealso}

* [Replica Set Controller (RST)](../../reference/internals/architecture/rsc.md) — реализация примитива деплоя.
