# Динамические ресурсы

Динамические ресурсы позволяют обновлять статические ресурсы pod'a без обновления DeployUnit'a, переаллокации pod`ов и перезапуска сервиса, опционально выполняя произвольное действие по результатам обновления.

Подробное описание механизма работы динамических ресурсов: [https://wiki.yandex-team.ru/deploy/dev/designdocs/dynresources-rfc/](https://wiki.yandex-team.ru/deploy/dev/designdocs/dynresources-rfc/)

## Требования {#requirements}

Для работы DRU необходим skynet. Во всех [расширенных образах](https://wiki.yandex-team.ru/runtime-cloud/virtualimages/#rasshirennyjjobraz) он присутствует. Для кастомного образа необходимо добавить следующий [слой](https://sandbox.yandex-team.ru/resource/922226367/view). Дополнительных действий не требуется, stagectl автоматически проставит опцию `bind_skynet: true` для боксов, использующих динамические ресурсы, и добавит сайдкар DRU.

## Спецификация {#specification}

Пример конфигурации:

```yaml
# внутри stage spec
dynamic_resources:
  # id динамического ресурса
  DResource1:
    deploy_unit_ref: 
      # Деплой юнит, к которому привязывается динамический ресурс
      DeployUnit1
    dynamic_resource:
      # Каждый ресурс может быть разбит на несколько т.н. групп деплоя,
      # для того чтобы наливать разные версии ресурса на разные группы хостов
      # внутри pod_set
      deploy_groups:
        # Группа обозначается текстовой меткой, для различения разных групп в статусе применения ресурса
        # Поскольку у нас в простом случае группа одна, мы напишем метку "all"
        - mark: all
          # Адреса, по которым можно скачать ресурс. Поддерживаются протоколы rbtorrent и http,
          # все неподдерживаемые игнорируются. Так, в данном примере мы указываем sandbox-ресурс,
          # чтобы иметь представление об источнике происхождения ресурса, но скачивание будет
          # вестись только по rbtorrent-ссылке
          urls: ["rbtorrent:25803faa1a155d72e6b6b3cb059ad117f96dd6c4", "sbr:123456789098"]
          storage_options: 
            # Имя box в поде, в который должен быть скачан ресурс
            box_ref: Box1
            # Существующий каталог, где будут храниться версии ресурса
            storage_dir: /place/my/storage
            # Место назначения ресурса: после скачивания каждой новой версии будет создана либо
            # обновлена символическая ссылка destination, ведущая на конкретную версию ресурса
            # в каталоге storage_dir
            destination: /service/target
            # После скачивания ресурса демон попытается сходить по указанному адресу и сверить ответ.
            # Если ответ не будет соответствовать ожидаемому, ресурс не будет считаться применённым и
            # будет произведён откат на предыдущую версию
            # аналогично можно указать exec_action и команду, которая выполнится в поде после скачивания ресурса
            http_action:
              url: "http://localhost:8080/"
              expected_answer: "ok"
            # Количество ревизий ресурса, которые необходимо хранить в box'е.
            # Старые копии используются для отката в случае ошибки в новой версии.
            # Хорошей идеей будет использовать всегда число не меньше 2 (текущая + предыдущая ревизии).
            cached_revisions_count: 3
      # Окно обновления ресурса. В каждый момент времени на последнюю заданную версию будет
      # пытаться обновиться число pod'ов в кластере, не большее заданного размера окна.
      update_window: 2
```

{% note warning %}

На данный критерием окончания успешной выкладки динамического ресурса всегда является завершённое обновление 90% подов (но не менее одного).
В будущем эта настройка будет вынесена в спецификацию динресурса.

{% endnote %}

{% note info %}

Смотрите детальную [спецификацию](https://a.yandex-team.ru/arc/trunk/arcadia/yp/client/api/proto/stage.proto?rev=7097088#L49-58).

{% endnote %}

StageCtl создаёт и поддерживает в актуальном состоянии сущность динамического ресурса в каждом кластере, используя в качестве id ресурса `"<stage_id>.<depoly_unit_id>.<dynamic_resource_id>"`, а также приносит в каждый box с динамическим ресурсом сайдкар с настроенным [DRU](https://wiki.yandex-team.ru/deploy/dev/designdocs/dynresources-rfc/#dostavkaresursa), который будет заниматься доставкой ресурса при обновлениях. При этом надо самостоятельно учесть требования к дополнительному месту в box в размере `cached_revisions_count * объем ресурса` и незначительные расходы CPU и памяти на демон обновления.

### Хранимые данные {#storage}

Workload DRU хранит в контейнере пользователя свою служебную информацию и непосредственно скачиваемые для пользователя ресурсы.

Служебная информация состоит из трёх небольших файлов: `dru.state`, `dru.infos` и `dru.log`, которые по умолчанию лежат в каталоге `/tmp`.

Ресурсы пользователя сохраняются в место, указанное пользователем в спецификации ресурса как `storage_dir`.
При этом каждая версия ресурса сохраняется в файле (если ресурс состоит из одного файла) или каталоге с именем, соответствующим номеру ревизии: т.е. `$storage_dir/1`, `$storage_dir/2` и т.д.
Исключением из этого правила являются откаты и перевыкладки: если требуется применить новую версию ресурса, но при этом среди хранящихся в контейнере версий (число регулируется опцией `cached_revisions_count`) есть версия с совпадающим набором url источников, то при условии консистентности данных ресурс будет браться из каталога старой ревизии, несмотря на то что фактический номер ревизии отличается. Пример для приведенных выше настроек:

1. Ревизия 1, url rbtorrent:abc, хранится в каталоге `/place/my/storage/1`.
1. Ревизия 2, url rbtorrent:cde, хранится в каталоге `/place/my/storage/2`.
1. Ревизия 3, url rbtorrent:abc, если ревизия 1 ещё не удалена, то хранится в каталоге `/place/my/storage/1`, иначе скачивается в каталог `/place/my/storage/3`.

Это позволяет практически мгновенно откатываться в случае проблем.

Кроме непосредственно данных создаётся ещё симлинк, который всегда ведёт на актуальную ревизию. Местоположение этого симлинка определяется параметром `destination` ресурса.
Таким образом, в вышеприведённом примере для ревизии 3 на диске может быть размещён, например, симлинк `//service/target -> /place/my/storage/1`, если старые данные сохранились на диске, или `/service/target -> /place/my/storage/3`, если их пришлось скачивать заново.
