# Resource Requests

Resource requests позволяют задавать вычислительные и сетевые ресурсы для пода.

Представлен следующей [proto схемой](https://a.yandex-team.ru/arc/trunk/arcadia/yp/client/api/proto/data_model.proto?rev=6549054#L1020-1041).

{% note warning %}

Итоговое значение ресурсов, выделяемых на под, складывается из:

- заказанных в рамках Resource requests;
- дополнительных ресурсов, выделяемых на запущенные в поде [сайдкары](sidecars/sidecars.md).

{% endnote %}


{% note info %}

1. По умолчанию при заказе ресурсов cpu/memory UI выставляет гарантию равной лимиту ([детали](https://clubs.at.yandex-team.ru/yp/298)).

   Разрешено указывать лимит на одно дополнительное ядро для временного решения проблемы с burst запросами. Если вам почему-то важны завышенные лимиты - приходите к команде YP, чтобы совместно решить что делать.

1. `thread_limit` на хостах RTC ограничен в `10000` на pod. Данное ограничение форсится node_agent и сформировано из-за ограничения числа тредов до ~1млн на уровне хоста: `min(sysctl kernel.pid_max, kernel.threads-max)` - см. комментарий [QLOUDDEV-2518](https://st.yandex-team.ru/QLOUDDEV-2518#5c7792a5ea51cd002295bcf3).

{% endnote %}

##  Как задать ресурсы через dctl {#dctl}

Стандартный заказ ресурсов обычно состоит только из `cpu` и общей памяти. Остальные параметры более специфичные, и их надо указывать только если вы знаете, что делаете.

```yaml
resource_requests:
  memory_guarantee: 209715200
  memory_limit: 209715200
  vcpu_guarantee: 1000
  vcpu_limit: 1000
```

`Cpu` указывается в **виртуальных** миллиядрах, тем самым, заказав `vcpu = 1000`, вы получите одно виртуальное ядро. Для каждой модели процессора путем специальных изменений назначается вычислительная мощность, выраженная в виртуальных миллиядрах. Значения калиброваны так, чтобы `1000` означало одно ядро (thread в смысле HT) процессора `Intel(R) Xeon(R) CPU E5-2650 v2 @ 2.60GHz` с учетом того, что на нем на остальных ядрах одновременно запущена некоторая каноническая нагрузка.

{% note alert %}

Запрещается выставлять лимит cpu, превышающий гарантию более чем на одно ядро.

{% endnote %}

Память указывается в байтах. Про различие между разными видами памяти можно почитать [вот тут](https://wiki.yandex-team.ru/porto/memory/).

##  Как задать ресурсы в UI {#ui}

В UI не так много опций, как в сырой спеке. Там можно указать только `vcpu_guarantee` и `memory_guarantee`, а лимиты будут выставлены равными гарантиям.
