# Статические ресурсы

Static resource — это файл или набор файлов, которые можно либо скачать из сети, либо захардкодить их содержимое прямо в спецификации, либо указать, что в этот файл надо записать значение секрета. Затем эти файлы можно смонтировать в заданный каталог любого [box](box.md).

У статических ресурсов нет последующей обработки после скачивания, поэтому нет возможности, например, скачать все одним архивом, распаковать его, и уже распакованные данные монтировать в бокс. Если вы хотите автораспаковку архивов, подумайте об использовании layer. Если вам нужна какая-то более сложная post обработка, ее можно сделать при помощи [init команд в box](box.md#init), но учтите, что вы, скорее всего, будете вынуждены скопировать ресурсы, что займет больше места на диске.

Каждый статический ресурс скачивается в отдельное специальное место в поде, а затем монтируется во все [box](box.md), где он указан в спецификации. Из-за того, что доставка ресурсов идет при помощи монтирования, есть некоторый набор ограничений на директорию `mount_point`. Нельзя монтировать в `"/"`, и `mount_point` не должны пересекаться. Поэтому, если у вас есть отдельный ресурс с бинарником приложения `app` и отдельный ресурс с конфигом `config.json`, вы не сможете смонтировать оба этих ресурса в одну директорию, более того, вы не сможете смонтировать `config.json` в поддиректорию приложения.

В качестве примера, вот такие пары `mount_point` **невалидны**: (`/my_app`, `/my_app`), (`/my_app`, `/my_app/config`).
Тем не менее, точки монтирования могут иметь общий префикс, поэтому вот эта пара **валидна**: (`/my_app/bin`, `/my_app/config`)

В деплое представлен следующей [proto схемой](https://a.yandex-team.ru/arc/trunk/arcadia/yp/client/api/proto/pod_agent.proto?rev=5791549#L187-223):

[Примеры использования](podagentpayload/resources/staticresource.md#examples)


## Виртуальный диск статического ресурса {#virtual-disk-ref}

{% include notitle [virtual-disk-static-resources](../../_includes/virtual-disk-static-resources.md) %}
