# Volume

Обеспечивает изоляцию по диску.

В Деплое слой представлен следующей [proto схемой](https://a.yandex-team.ru/arc/trunk/arcadia/yp/client/api/proto/pod_agent.proto?rev=5791549#L324-340):

## Персистентность {#persistence}
Данные вольюма будут потеряны, если:

* pod переезжает на другой хост
* (или) спека вольюма изменилась
* (или) слои данного конкретного вольюма (или другие зависимости) изменились

{% note info %}

* Данные потеряются только если поменять слои данного конкретного вольюма. То есть, если поменять слои в рутовом вольюме, то данные потеряются только в нём, а других вольюмах (персистентных) не потеряются.
* Все гарантии сохранности данных соблюдаются только если под в процессе деплоя не будет перенесён на другой хост. При переносе пода данные теряются в любом случае. Перенос подов в Деплое сейчас может происходить при выкладе новой версии спеки.

В остальных случаях данные сохраняются.

{% endnote %}

Вольюм можно использовать для персистирования данных между ревизиями.
Например, вот так можно класть ваши логи в отдельный вольюм, примонтированный к боксу:

```yaml
volumes:
- id: logbroker_push_agent_logs
  generic: {}
boxes:
- id: logbroker_tools_box
  rootfs:
    ...
  volumes:
  - mode: read_write
    mount_point: /logs
    volume_ref: logbroker_push_agent_logs
```

Кроме того, один вольюм можно примонтировать к нескольким боксам.

## Виртуальный диск вольюма {#virtual-disk-ref}

В случае, если у вас больше одного диска, необходимо указать `virtual_disk_id_ref`, чтобы вольюм попал в place нужного диска. Данный `virtual_disk_id_ref` должен совпадать с аналогичным полем в леерах, из которых собирается вольюм, в статических ресурсах, которые монтируются в вольюм, и в бокс, в котором этот вольюм используется. Иначе спека не пройдет валидацию.

```yaml
volumes:
- id: logbroker_push_agent_logs
  generic: {}
  virtual_disk_id_ref: disk-0
boxes:
- id: logbroker_tools_box
  rootfs:
    ...
  virtual_disk_id_ref: disk-0
  volumes:
  - mode: read_write
    mount_point: /logs
    volume_ref: logbroker_push_agent_logs
```

[Пример полной спеки с использованием нескольких дисков.](https://deploy.yandex-team.ru/docs/concepts/pod/diskvolumerequests#primer-speki-s-ispolzovaniem-neskolkih-diskov)
