# Временное изменение deployment strategy

Временное изменение deployment strategy нужно тем, кто хочет в рамках одной ревизии повысить или понизить скорость выкладки.

На текущий момент настроить временное изменение значений deployment strategy возможно ручным вызовом команды в **dctl** или **YP API**, либо в **UI**.

## Механика
Сейчас из всех настроек deployment strategy доступна только перегрузка [Disruption budget](deploy-unit/deploy-primitives.md#disruption-budget). Соответствующее поле в запросе — `max_unavailable`. Механика работает для определенных ревизии, деплой юнита, кластеров.

Чтобы сделать это в `dctl`, нужно вызвать следующую команду:
```bash
ya tool dctl control stage override_deployment_strategy <stage_id> --cluster-to-override sas --cluster-to-override man --revision 16 --deploy-unit-id deployUnit --max-unavailable 3 -c xdc
```
Можно указывать сразу несколько кластеров, в которых есть реплики.
В YP API команда выглядит так:

```bash
ya tool yp update stage <stage_id> --set /control/override_deployment_strategy '{max_unavailable={deploy_unit_id=deployUnit;revision=16;value=3;clusters=[sas;man;];};}' --address xdc
```

В UI для каждого реплика-сета есть таб `Disruption budget`, где можно переопределить значение. Все параметры будут взяты из текущего деплой юнита и показаны в сообщении при подтверждении действия.

При следующем изменении деплой юнита эти настройки будут сброшены. Введенная ревизия должна обязательно соответствовать текущей ревизии деплой юнита, деплой юнит должен существовать, кластера должны быть использованы в деплой юните, иначе будет ошибка валидации.

Замечу, что перегрузка опций deployment strategy не приводит к изменению ревизий.

## FAQ
Q: Я хочу, чтобы настройки перегрузки применились до начала выкладки, как это сделать?
A: **Пользуйтесь транзакциями YP или [полокационной выкладкой с подтверждением](perlocation.md).**

Q: Будет ли видно, кто изменил настройки выкладки в какой-то момент времени?
A: **Да, запоминается логин владельца токена и потом это планируется отображать в истории.**

