# Нагрузочное тестирование

## Введение
Нагрузочное тестирование - важный и полезный инструмент для разработки и поддержки сервиса. Рекомендуется проводить его наравне с другими видами тестирования. Нагрузочные тесты позволяют проверить сервис в ситуации, приближенной к реальной, и выявить:

- Слабые стороны кода;
- Граничные условия эксплуатации;
- Возможную деградацию при разработке нового релиза;
- Проблемы внутреннего взаимодействия с другими сервисами;
- Неэффективное использование ресурсов;

Более подробно о пользе таких тестов рассказано в статье "[Зачем проводить нагрузочное тестирование](https://wiki.yandex-team.ru/load/manager/#why)".

## Этапы тестирования
Для проведения тестов следует:

- Подготовить нагрузочный стенд
- Определиться с генератором нагрузки
- Сформировать список запросов, который будет подан на сервис в качестве нагрузки - "патроны";
- Выбрать танк: общественный или развернутый в своей квоте;
- Выбрать способ запуска;
- Научиться анализировать результаты;
- Настроить автоматизацию.

Нагрузочное тестирование **настоятельно рекомендуется проводить в рамках одного ДЦ** для нивелирования влияния сетевых лагов, задержки и посторонних шумов.
Исключением являются случаи, когда целью теста является проверка кросс ДЦ взаимодействия. При подготовке стрельб следует внимательно отнестись к соответствию параметров окружения мишени и планируемой нагрузки. Если тестирование подразумевает высокий уровень рпс или весомый объем отдельно взятых запросов, то ресурсы сетевой карты, а также CPU и память должны быть в состоянии обработать поданный трафик.

## Подготовка стенда
Для проведения тестов желательно иметь изолированный от продакшн окружения стенд. Для этого можно эмулировать ключевые сервисы через моки. Подробнее об этом можно почитать [тут](https://wiki.yandex-team.ru/Load/guides/mocks/).

Со стороны Y.Deploy особых требований к нагрузочному стенду не предъявляется, но для точности теста желательно выделить ресурсов  эквивалентно одному инстансу production версии. Также не стоит полагаться на сохранение серверного окружения при редеплое стенда. По умолчанию это не так, что может отразиться на результатах теста.

## Генератор нагрузки
Выбор генератора зависит от планируемой нагрузки и способа запуска теста. [Тут](https://wiki.yandex-team.ru/Load/themethod/choosing_tools/) описаны генераторы нагрузки которые предоставляет Яндекс.Танк. Для более простых http тестов можно использовать генератор [Phantom](https://wiki.yandex-team.ru/load/guides/ammo/). В случае сложных сценарных тестов и тестов на несколько протоколов рекомендуется использовать генератор [Pandora](https://wiki.yandex-team.ru/Load/Pandora/).

## Подготовка патронов
Для того, чтобы нагрузить сервис, вы должны определиться с набором запросов, которые будут отправляться во время теста. Для разных генераторов нагрузок доступны и приемлимы разные форматы.

Подробнее это можно почитать в документации:
[phantom](https://wiki.yandex-team.ru/load/guides/ammo/)
[pandora](https://wiki.yandex-team.ru/Load/Pandora/)

## Подготовка танка
Для тестирования сервисов в Deploy можно использовать публичные танки из [RTC пула](https://wiki.yandex-team.ru/load/howto/TankHowTo/#tankivrtc). Это вполне оправданный шаг для стрельб непродолжительных и без большой генерации траффика.
Для автоматического выбора танка в общем с мишенью ДЦ следует указать параметр `'nanny:production_yandex_tank'` в секции uploader конфигурации стрельбы или же указать FQDN конкретного танка.

Пример конфигурации для Uploader

```yaml
uploader:
  api_address: https://lunapark.yandex-team.ru/
  enabled: true
  job_dsc: example
  job_name: '[example][{"duration": "100s", "type": "const", "ops": 100}][Some comment]'
  jobno_file: jobno_file.txt
  meta:
    use_tank: nanny:production_yandex_tank
    use_tank_port: '8083'
  operator: lunapark
  package: yandextank.plugins.DataUploader
```


Если же:

* необходимо минимизировать влияние сетевой инфраструктуры;
* обеспечить высокую доступность танка;
* тесты достаточно продолжительны по времени;
* запросы могут содержать большой объем информации;
* планируется проводить частое тестирование;
* необходимо обеспечить большую приватность данных стрельбы.

рекомендуется использовать собственный танк. Как поднять собственный танк в Deploy можно узнать [здесь](https://wiki.yandex-team.ru/users/lix0/TankInDeploy/).
Если для стрельб задействован общественный танк, необходимо заказать [доступы](https://wiki.yandex-team.ru/Load/howto/idm-puncher/.) до обстреливаемых портов в сетевом макросе мишени для сетевого макроса `_GENCFG_ALL_RCLOUD_TANKS_`.
Если используется собственный танк, то для него необходимо заказать доступ до агрегатора стрельб: `slb-lunapark.yandex-team.ru:443`
Также следует отметить, что если для запуска стрельбы (см. ниже) планируется использовать sandbox, то могут потребоваться [дополнительные доступы](https://wiki.yandex-team.ru/sandbox/firewall/). Так, в случае использования собственного танка, будет нужен доступ к нему на порт, на котором будет запущен tankapi.

## Cпособ запуска
Запуск теста может быть осуществлен разными способами:

- Для разовых и нерегулярных стрельб, а также на этапе пристрелки можно использовать компонент [firestarter](https://lunapark.yandex-team.ru/firestarter/) в лунапрарке (подробнее [тут](https://wiki.yandex-team.ru/load/lunapark/firestarter/)).
- Для регулярных стрельб и настройки автоматизации нагрузочного тестирования рекомендуется использовать задачу [ShootViaTankpi](https://wiki.yandex-team.ru/load/tanks-sandbox/)
- Также, в других CI системах можно настроить процесс запуска стрельб через использование утилиты [tankapi-cmd](https://clubs.at.yandex-team.ru/tanks/1034) или [sandbox API](https://wiki.yandex-team.ru/sandbox/api/).

## Анализ результатов
Чтение отчёта в лунапарке подробно описано [тут](https://wiki.yandex-team.ru/Load/howto/reading_a_report/).

## Создание регрессионных стрельб
Для ведения истории стрельб с возможностью отслеживания изменений в результатах и оперативного получения информации о качестве кода можно использовать в стрельбах компонент регрессии. О том, как можно настроить регулярное регрессионное тестирование, подробно описано [здесь](https://wiki.yandex-team.ru/Load/guides/HowToRegress/).
Если стрельбы организованы через задачу в sandbox, то для неё можно настроить [планировщик запуска](https://wiki.yandex-team.ru/sandbox/cookbook/#kakzapuskatzadachuporaspisanijuiliposhablonu) с компонентом регрессии, что позволит получить сводку состояния сервиса в течении продолжительного периода.
Следует заметить, что изменение параметров окружения при редеплое сервиса может оказать влияние на результаты нагрузочных тестов (тайминги, данные мониторинга). Если стабильность результатов стрельб для ваших сервисов критически необходима и нет возможности решить этот вопрос иными способами (например, через исследование медианы для серии стрельб), то вопрос возможности фиксации окружения для сервиса можно обсудить с командой [RTC Support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q) при наличии обоснований для подобного запроса.

## Ссылки
* [ Страница группы нагрузочного тестирования](https://wiki.yandex-team.ru/Load/)
* [Документация Яндекс.Танка](https://yandextank.readthedocs.io/en/latest/)
* [Лунапарк](https://lunapark.yandex-team.ru/)
* [ Документация по Лунапарку](https://wiki.yandex-team.ru/Load/lunapark/Firestarter/)
* [Чат поддержки](https://t.me/joinchat/AAAAAD-zGT5mLOoGc_N-kw)

