# Базовая настройка балансировки

## О чём документ? {#intro}

Опишем, как настроить простейшую балансировку на инстансы в Я.Деплое. Результатом наших действий должен стать развёрнутый балансер, доступный по адресу `myservice.in.yandex-team.ru`, обрабатывающий HTTPS-трафик.

Если нужно завести **L3 балансер**, воспользуйтесь [вот этой инструкцией](https://wiki.yandex-team.ru/cplb/awacs/tutorial/L3-L7/#sozdaniel3-balanceera).

## Общая информация {#common}

Для настройки балансировки на инстансы в Я.Деплое используется сущность **Endpoint Set**.

С каждым endpoint set'ом связано (в упрощённом виде) множество пар вида `(ipv6_address, port)`, на которые может направлять трафик балансер (или другие клиенты, если сервис предполагает поход в инстансы без балансера).
Зная Endpoint Set сервиса, балансер может ходить в YP и получать соответствующие конкретные адреса инстансов, что он и делает раз в минуту, обнаруживая таким образом переезды инстансов сервиса.
На текущий момент при создании любого stage'а в Я.Деплое автоматически создаются endpoint set'ы во всех локациях, где он представлен.

## Как работает в Y.Deploy? {#details}

Мы будем настраивать балансировку в awacs с использованием DNS-балансера. Данный балансер предназначен для человеческого трафика или тестовых сервисов. Если нужна более высокая надёжность, можно [завести в awacs L3-балансер](https://wiki.yandex-team.ru/cplb/howtocreatebalancer/#kakrazvernutl3-balanserdljaservisa), однако это сейчас можно сделать только через UI awacs. Тикет на доработку: [https://st.yandex-team.ru/AWACS-518](https://st.yandex-team.ru/AWACS-518)

Для запуска балансера потребуются вычислительные ресурсы (CPU, память), объём выделяемых ресурсов можно выбрать в форме его создания.

### Полезные ссылки {#links}

[Подробная документация про создание балансеров в awacs](https://wiki.yandex-team.ru/cplb/awacs/tutorial/)

## Последовательность действий {#workflow}

1. Переходим на вкладку **BALANCERS** на странице стейджа и жмём кнопку **Launch a new balancer**.
2. Указываем, идентификатор создаваемого балансера, заполняя поля `Hostname` и `Domain`. При этом прямо сейчас через UI Деплоя не получится завести L3-балансер, поэтому чтобы балансер был доступен по получившемуся FQDN (кроме `in.yandex-team.ru`), придётся идти напрямую в awacs. Однако создаваемый балансер может быть доступен через DNS-балансировку, которую мы включим следующей галкой.
3. Выставляем галку **Create a DNS Record** для включения DNS-балансировки. DNS-балансировка работает только для доменов `*.in.yandex-team.ru` или `*.in.yandex.net`, по ним и будет доступен наш сервис. При этом он может быть доступен одновременно по адресу `my-stage.in.yandex-team.ru` через DNS-балансировку, и по адресу `my-stage.yandex-team.ru`, если настроить L3-балансер напрямую в awacs.
4. Указываем ABC-сервис проекта, для которого поднимается балансер.
5. Выбираем тот же `Network macro`, который использовали при создание ReplicaSet (для того, чтобы был доступ от инстансов балансера до инстансов сервиса, поднятого в deploy). Если доступ будет через DNS-балансер, то необходимо, чтобы у пользователя тоже был доступ до данного макроса.
6. Указываем кластера, в которых нужно запустить балансер.
7. Эндпоинтсеты, на которые нужно направить трафик. Список эндпоинтсетов существующего стейджа будет подставлен автоматически. Балансер получит адреса [только тех бекендов, которые прошли readiness_check](https://wiki.yandex-team.ru/ru/servicediscovery/#endpointlifecycle). Задержка обновления эндпоинтов - порядка минуты.
8. Нажимаем кнопку **Save** и наблюдаем за процессом создания балансера. В процессе подготовки балансера awacs сделает следующее:

    * Запросит у DNS-балансера включение DNS-балансировки для нашего домена `myservice.in.yandex-team.ru`;
    * Выпишет HTTPS-сертификат для указанного домена и для DNS-балансировки;
    * Развернёт инсталляцию L7-балансера, отправляющую трафик на 80-ый порт нашего сервиса.

Балансер начнёт работать, когда перейдёт в статус `Ready`. После этого можно из браузера сделать запрос к `myservice.in.yandex-team.ru`.

