# Руководство по запуску сервиса

Добро пожаловать в Deploy! 

Цель этого руководства - помочь вам создать сервис и настроить все необходимое. Вы создадите и развернете сервис с использованием CI/CD, a также узнаете о том, как настраивать мониторинг, логирование, балансировку и многое другое!

Давайте рассмотрим структуру типового проекта в Deploy и базовые сущности.

## Структура сервиса в Deploy {#service-strucure}

Пройдемся по структуре снизу вверх, от приложения до проекта.

### Box и Workload {#box-workload}

**Workload** - приложение, бинарь, микросервис, скрипт - пользовательский процесс-демон. 

В Workload указываются параметры запуска, проверки готовности и живости процесса, логи, unistat url для сбора метрик, сбор корок и локальные переменные окружения.

**Box** - контейнер, файловая система, docker образ, porto слои.

В Box указываются сетевые настройки, ограничения по ресурсам, общие для Workload переменные окружения, базовые слои вашего приложения (docker/porto), статические и динамические ресурсы.

Другими словами, именно в Box мы определяем файлы, запуск которых настраивается в Workload'ах.

Все Workload'ы, запущенные в одном боксе, будут иметь общую файловую систему. Сеть между боксами не изолирована - workload'ы разных боксов могут общаться друг с другом по localhost.

Боксы обновляются независимо друг от друга (если в новой ревизии не изменились ресурсы/вольюмы, от которых зависят оба бокса). Для связи боксов можно создать общий [volume](../concepts/pod/volume.md), примонтированный к нескольким боксам.

Если у вас есть некое "сайдкар" - приложение (workload), которое хочется обновлять независимо от "основного", можно выделить для него отдельный бокс. Например, каждый из инфраструктурных "сайдкаров" типа logbroker или tvmtool запускается в своем боксе. Раскатка релиза нового бинарника logbroker не аффектит пользовательские боксы/приложения.

### Deploy unit и Pod {#pod-deploy-unit}

Тут важно ввести понятие Pod. 

**Pod** - Минимальная единица управления деплоя, агрегирующая сущность для Box, Workload, для нее доступны FQDN, net/mount/pid ns. Именно Pod'ы создаются и запускаются в датацентрах, настраивается их количество для распределения нагрузки, Pod'ы отображаются в UI Deploy и мониторингах, имеют свою ревизию и т.д.

**Deploy unit** — это сущность, которая управляет группами одинаковых Pod в соответствии с выбранной политикой деплоя, сколько Pod'ов с какими ресурсами в каких дата центрах запустить в какой последовательности. Другими словами, N одинаковых Pod'ов = Deploy Unit.

Настраивая Deploy unit, мы указываем самое большое количество параметров, изоляцию подов по сети, дата центры, ресурсы, диски, политику деплоя, настройки агентов, мониторингов и логов.

Также на уровне Deploy unit задаются секреты и настройки для доступа к другим сервисам через TVM.

### Stage {#stage}

**Stage** - группа deploy unit, выкладка которых оркестрируется между собой.

Stage удобная верхнеуровневая сущность, например, для разделения окружений (testing, pre-stable, stable) или объединения разных, но связанных логически Deploy unit (backend + frontend).

В Деплое реализовано раздельное версионирование deploy unit'ов в рамках одного стейджа. Это позволяет вносить изменения и управлять выкладкой более гранулярно - при изменении настроек deploy unit'а будет изменена только его ревизия, что приведет к обновлению подов конкретного deploy unit'а, а не всех подов всех deploy unit'ов стейджа.

### Проект {#project}

Проект это сущность, предназначенная для:

* Логического разделения сервисов между собой
* Группировки Stage 
* Связи с ABC сервисом
* Выдачи ролей на все стейджи проекта

## Примеры организации проекта {#project-sample}

![project-sample](../_assets/how-to/project-sample.png)
