# Настройка мониторингов в Deploy.

Деплой позволяет настроить в своем сервисе сбор как количественных метрик мониторинга в [YASM (Golovan)](https://wiki.yandex-team.ru/golovan/userdocs/), так и отправку событий в систему событийного мониторинга [Juggler](https://docs.yandex-team.ru/juggler/).

## Настройка отправки метрик в YASM {#yasm}
Деплой позволяет настроить формирование и отправку сигналов нескольких типов:
* метрики потребления ресурсов контейнера (пода) приложения
* метрики потребления ресурсов отдельного ворклоада пода
* метрики pod agent'а
* метрики пользовательского приложения

### Общая информация
Настройки сбора метрик хранятся в структуре [TMonitoringInfo](https://a.yandex-team.ru/arc/trunk/arcadia/yp/yp_proto/yp/client/api/proto/host_infra.proto?rev=r8051118#L81).

Перед настройкой сбора метрик необходимо определиться, с какими [тегами](https://wiki.yandex-team.ru/golovan/userdocs/terminology/#tegi) будут собираться метрики.
По умолчанию Деплой заполняет следующие теги:
* `stage` - имя стейджа Деплоя
* `deploy_unit` - имя деплой юнита
* `workload` - имя ворклоада, заполняется только для метрик потребления ресурсов отдельным ворклоадом
* `prj` - имеет формат <stage_id>.<deploy_unit_id>. (Note: На текущий момент такой формат `prj` не является публичным контрактом и завязываться на него не стоит)
* `geo` - соответствует имени ДЦ, в котором запущены поды сервиса (Примечание: для подов в ДЦ MYT и IVA значение тега равно `msk`)
* `itype` - по умолчанию имеет значение `deploy`. Переопределяется пользователем. (как-то специально создавать новый itype не нужно, просто указываете его в спеке или в UI).

{% note alert %}

Не рекомендуется использовать дефолтное значение тега `itype = deploy`. Сигналы с дефолтным значением тега itype хранятся в коммунальной квоте с пониженными гарантиями времени хранения метрик. Значение тега `itype = deploy` не рекомендуется для сбора сигналов мониторинга с production сервисов.

{% endnote %}

Дополнительно пользователь может заполнить теги `itype`, `ctype`, `tier`.
При необходимости использования более широкого набора тегов необходимо "зарегистрировать" их в Головане для своего itype - подробности в [документации](https://wiki.yandex-team.ru/golovan/userdocs/user-tags/).

### Метрики потребления ресурсов контейнера {#porto-metrics}
[Метрики потребления ресурсов контейнера](https://rtc.yandex-team.ru/docs/containers/metrics-diagnostics) собираются автоматически для всех контейнеров, поднятых в Деплое, и имеют префикс `portoinst-*`.

Метрики собираются с тегами, указанными пользователем. Задать метрики можно в UI в разделе `Monitoring in YASM` на странице редактирования настроек деплой юнита.
**Примечания**.
1. Саджест при вводе тегов показывает значения, про которые знает Голован. Можно задавать значения, которых нет в саджесте.
2. Новые значения тегов "прорастают" в саджест обычно в течение 10-15 минут.

В UI Deploy на странице стейджа во вкладке `Monitoring` доступна [панель](https://deploy.yandex-team.ru/docs/reference/monitorings/panels) с основными системными метриками приложения. Для создания собственных панелей необходимо воспользоваться [соответствующими инструментами в Головане](https://wiki.yandex-team.ru/golovan/userdocs/panels/).

### Метрики потребления ресурсов инфраструктурных сайдкаров {#infra-workload-metrics}
Сбор метрик потребления ресурсов инфраструктурными ворклоадами по умолчанию не осуществляется, для включения должны быть выполнены два условия:
* Использована Runtime Revision не ниже шестой версии
* Установлен [флаг](https://a.yandex-team.ru/arc/trunk/arcadia/yp/yp_proto/yp/client/api/proto/stage.proto?rev=r8516331#L242) в интересующем DeployUnit'е

Метрики имеют префикс `portoworkload-*` и следующие `itype`:
* `deploy_sidecar_tvm`
* `deploy_sidecar_logs`
* `deploy_sidecar_dru`
* `deploy_sidecar_juggler`

Для метрик автоматически проставляются соответствующие теги `stage` и `deploy_unit`.

### Метрики потребления ресурсов отдельного ворклоада {#workload-metrics}
Сбор метрик потребления ресурсов отдельного ворклоада по умолчанию не осуществляется и имеет следующие ограничения:
* не должен использоваться дефолтный `itype = deploy`
* заданы CPU/RAM лимиты на start command workload'а (Advanced settings в блоке start command на странице редактирования настроек workload'а)
* включение сбора портометрик осуществляется отдельно для каждого ворклоада

Метрики имеют префикс `portoworkload-*`.

Для включения сбора поворклоадных метрик необходимо включить переключатель  `Per workload porto metrics` и указать необходимые теги, с которыми будут собираться метрики. Существует возможность переиспользовать теги, заданные для всего пода (на странице настроек Deploy unit'а) - для этого необходимо включить галку `Inherit missing labels`. При включенном наследовании  отсутствующие в настройках workload'a лейблы дополняются соответствующими из настроек pod'а.

### Метрики pod agent'а {#pod-metrics}
[Базовые метрики работы pod agent'а](https://deploy.yandex-team.ru/docs/reference/monitorings/user-sensors/objectconditions#pod) собираются автоматически для всех подов, поднятых в Деплое.
У сигналов проставлен `itype = pod_agent`, остальные теги совпадают с тегами метрик потребления ресурсов.

Начиная с версии pod agent 93 существует возможность включить сбор [дополнительных метрик объектов внутри пода](https://deploy.yandex-team.ru/docs/reference/monitorings/user-sensors/user-sensors). Для этого необходимо на странице редактирования настроек deploy unit'а в секции `Monitoring in YASM` включить опцию `Add pod agent user signals`.

### Метрики пользовательского приложения {#user-metrics}
Деплой позволяет настроить сбор пользовательских метрик в Голован по pull-схеме через unistat-ручку. Оригинальная документация yasm [тут](https://wiki.yandex-team.ru/golovan/userdocs/stat-handle/)

#### Подготовка приложения
Приложение должно возвращать список метрик в json формате на порту и пути, заданными пользователем. Порт должен быть поднят на `::`, а не `localhost`, так как yasm-agent собирает данные из `<FQDN>:<port><path>` и не имеет доступа к `localhost:<port>`.

#### Конфигурация стат-ручки
Настройки сбора пользовательских метрик осуществляются на странице настроек
Необходимо в поле `unistat` и `port` задать соответствующие значения. В данном примере `unistat=/unistat` `port=8080`

Существует возможность переиспользовать теги, заданные для всего пода (на странице настроек Deploy unit'а) - для этого необходимо включить галку `Inherit missing labels`. При включенном наследовании  отсутствующие в настройках unistat'a лейблы дополняются соответствующими из настроек workload'а и далее pod'а.

{% note info %}

В Аркадии для разных языков есть библиотеки или примеры реализации отправки метрик в Yasm в формате unistat. Например,
* [C++](https://a.yandex-team.ru/arc/trunk/arcadia/library/cpp/unistat)
* [Python](https://a.yandex-team.ru/arc_vcs/infra/yasm/unistat)
* [Go](https://a.yandex-team.ru/arc/trunk/arcadia/library/go/yandex/unistat)
* [Typescript](https://a.yandex-team.ru/arc_vcs/frontend/projects/infratest/packages/unistat-metrics)

{% endnote %}

## Настройка отправки событий в Juggler {#juggler}

Если вам необходимо отправить в Juggler сырые события, генерируемые вашими приложениями, дополнительной настройки в Деплое не требуется - можно напрямую посылать события в глобальный шлюз juggler-push. Подробности - в [документации Juggler](https://docs.yandex-team.ru/juggler/raw_events#global-push).

Для сбора результатов [пассивных проверок](https://docs.yandex-team.ru/juggler/client/bundles) событийного мониторинга в Деплое необходимо подключить и настроить субагент Juggler.
Для этого необходимо:
* подключить [сайдкар](https://deploy.yandex-team.ru/docs/concepts/pod/sidecars/jugglersubagent) с субагентом джагглера с помощью переключателя `Juggler alerting` в настройках бокса вашего deploy unit'а
* указать порт, на котором будет работать субагент
* указать список [бандлов](https://docs.yandex-team.ru/juggler/client/bundles#how-to-build) с проверками, которые будут скачаны в бокс. Бандлы можно задать через http(s) или rbtorrent идентификатор.

{% note info %}

**Для каждого box c juggler subagent** в Поде будут запрошены дополнительные ресурсы:

* 512 МБ диска.
* 256 МБ RAM.
* 0.13 ядра CPU.

Сумма этих ресурсов будет прибавлена к запрашиваемым ресурсам Пода.

{% endnote %}

## Базовые панели метрик сервиса в Деплое

###  Панель состояния сервиса в Деплое
На вкладке Monitoring страницы стейджа в Деплое отображается агрегированная информация для выбранного deploy unit'а (выбирается в выпадающем списке, [пример](https://jing.yandex-team.ru/files/pirogov/Снимок%20экрана%202020-07-06%20в%2016.47.47.png)).
В головане панель доступна по адресу [https://yasm.yandex-team.ru/template/panel/yd-container-non-lvm-pod-level/](https://yasm.yandex-team.ru/template/panel/yd-container-non-lvm-pod-level/) и принимает на вход следующие параметры:

* `hosts` - агрегат (ASEARCH) или конкретный хост, метрики которого надо отобразить
* `itype` - itype голована, с которым собираются метрики в данном deploy unit'e
* `stage` - имя stage
* `deploy_unit` - имя deploy unit'a


###  Панель состояния хоста, на котором живет Pod сервиса Деплоя
Панель позволяет посмотреть на основные системные метрики живости хоста и хостовой инфраструктуры.
Панель доступна по адресу [https://yasm.yandex-team.ru/template/panel/Host/,](https://yasm.yandex-team.ru/template/panel/Host/) принимает следующие параметры:

* `hosts` - fqdn dom0-хоста, метрики которого надо отобразить
