# Логирование

На данный момент возможны следующие варианты отгрузки логов из приложения:

1. Отгрузка логов через [стандартный механизм](standard-mechanism.md) (поставка логов через LogBroker):
    - Автоматическая доставка [STDERR/STDOUT стартового контейнера](write.md#stdout_stderr):
    - работает "из коробки" без дополнительных настроек и кода;
    - Возможность дополнительной доставки логов через [клиентские библиотеки](write.md#libs):
      - Java;
      - C++;
      - Python.
    - Специальный [формат](format.md) данных, обогащенный метаинформацией;
    - Независимо от способа доставки логи можно отгружать в:
      - [коммунальный топик](topic.md#communal-topic) — общее хранилище для всех пользователей;
      - [пользовательский топик](topic.md#custom-topic) — собственное хранилище пользователя.
1. [Ручное развертывание](#manual-unified-agent) Unified Agent:
    - актуально, если не устраивает весь [стандартный механизм](standard-mechanism.md) отгрузки;
    - позволяет отгружать данные сразу в несколько топиков.


## Просмотр init, readiness и liveness логов {#init-readiness-liveness}

Сейчас логи проб не поставляются в logbroker. Логи можно читать стандартными способами: [{#T}](../concepts/pod/pod.md#chtenie-logov-pod_agent)

## Ручное развертывание Unified Agent {#manual-unified-agent}

Если пользователя по каким-то причинам не устраивает стандартный механизм отгрузки логов, то можно развернуть workload Unified Agent напрямую через спеку: [Инструкция по ручному развертыванию Unified Agent](https://wiki.yandex-team.ru/users/alexbogo/ua-in-deploy-instuction/).

## Отправка сообщений в error-booster {#error-booster}

Deploy поддерживает нативную интеграцию поставки данных в [ErrorBooster](https://docs.yandex-team.ru/error-booster/) через сайдкар Unified Agent.
Документация по подключению описана в [доке ErrorBooster](https://docs.yandex-team.ru/error-booster/error-how-to/#kakpodkljuchitsja).

## FAQ {#faq}

> Можно ли отправлять логи не в `//logs/deploy-log`, а куда-нибудь к себе в уютное место с квотой в YT?

Да, можно. Для этого нужно настроить отправку в [самостоятельно настроенный топик](topic.md#custom-topic) или вообще полностью [кастомизировать UnifiedAgent](https://wiki.yandex-team.ru/users/alexbogo/ua-in-deploy-instuction/).

> Можно ли прямо из своей программы как-то писать логи, чтобы они выглядели хорошо в Y.Deploy: чтобы переопределялся source, level, ...? Могу ли я как-то так структурировать stdout/stderr, чтобы утилизировать колонку level?

Да, можно писать логи с помощью [клиентских библиотек](write.md#libs), заполняя необходимые поля. Вот тут подробное [описание формата](format.md#schema). Нужно использовать `levelStr` или `level`.

> Как люди вообще пишут логи из deploy? У каждого свой unified agent настроенный в stage, руками (не через интерфейс деплоя), под свои задачи, который уже пишет кому как угодно куда угодно?

Большинство пользователей пишет в коммунальный топик. Кастомные топики пока используются редко, для наглядности — [метрика с количеством стейджей/деплой-юнитов, использующих кастомный топик](https://yasm.yandex-team.ru/panel/alexsmir3.DeployStatistics/46148019-c2bf-352a-38ea-ca7e0b0d1719/?range=604800000).

#### См. также: {#see-also}

* [{#T}](../launch/logs.md)
* [{#T}](gui.md)

