# Быстрый запуск сервиса/Как начать работать с Y.Deploy

С помощью этой инструкции вы запустите свой первый сервис в Y.Deploy и познакомитесь со структурой типового проекта. В процессе вы создадите минимально необходимые ресурсы для сервиса, настроите и развернете собственный http-сервер. Для этого:

1. [Перед началом работы](#intro).
1. [Создайте Project и Stage](#project-stage).
1. [Настройте Deploy Unit](#deploy-unit).
1. [Настройте Box и Workload](#box-workload).
1. [Запустите деплой сервиса](#deploy).
1. [Протестируйте работу сервиса](#test).

Если сервис вам больше не нужен, удалите все используемые им ресурсы.

## Перед началом работы {#intro}

Перед запуском первого сервиса ознакомьтесь со структурой типового проекта в Y.Deploy и базовыми сущностями. Рассмотрим структуру самого простого сервиса снизу вверх: от нижнего уровня приложения до верхнего уровня проекта.

![sample-project-structure](_assets/how-to/sample-service-structure.png)

Самый нижний уровень представляет [Workload](concepts/pod/workload/workload.md) — это приложение, бинарь, микросервис, скрипт; по сути — пользовательский процесс-демон. В Workload указываются параметры запуска, проверки готовности и живости процесса, логи, unistat url для сбора метрик, сбор корок и локальные переменные окружения.

Workload расположен внутри [Box](concepts/pod/box.md) — контейнера, файловой системы, docker образа, porto слоёв. В настройках Box указываются ограничения по ресурсам, общие для Workload переменные окружения, базовые слои вашего приложения (docker/porto), статические и динамические ресурсы. Другими словами, именно в Box мы определяем файлы, запуск которых настраивается в Workload'ах.

Обратите внимание, что на схеме кроме пользовательских боксов есть еще 2 инфраструктурных бокса (c PushAgent и с TVM-Tool) – это примеры так называемых [sidecars](concepts/pod/sidecars/sidecars.md).


{% note info %}

Все Workload'ы, запущенные в одном боксе, будут иметь общую файловую систему. Сеть между боксами не изолирована — workload'ы разных боксов могут общаться друг с другом по localhost.

Боксы обновляются независимо друг от друга (если в новой ревизии не изменились ресурсы/вольюмы, от которых зависят оба бокса). Для связи боксов можно создать общий [volume](concepts/pod/volume.md), примонтированный к нескольким боксам.

Если у вас есть некое "сайдкар" — приложение (workload), которое хочется обновлять независимо от "основного" то, можно выделить для него отдельный бокс. Например, каждый из инфраструктурных "сайдкаров" типа logbroker или tvmtool запускается в своем боксе. Раскатка релиза нового бинарника logbroker не аффектит пользовательские боксы/приложения.

{% endnote %}

Уровнем выше Box находится **Deploy Unit**, который служит для оркестрации Pod'ами. [Pod (Под)](concepts/pod/pod.md) — это основная и минимальная единица управления деплоя, агрегирующая сущность для Box, Workload. Для Pod доступны такие настройки как FQDN, net/mount/pid ns. Именно Pod'ы создаются и запускаются в датацентрах, настраивается их количество для распределения нагрузки, Pod'ы отображаются в UI Deploy и мониторингах, имеют свою ревизию и т.д.

[Deploy unit](concepts/deploy-unit/deploy-unit.md) — это сущность выше Box (и Pod), которая управляет группами **одинаковых Pod** в соответствии с выбранной [политикой деплоя](concepts/deploy-unit/deploy-primitives.md): сколько Pod'ов, с какими ресурсами, в каких дата центрах запустит, в какой последовательности. Можно сказать `Deploy Unit = N * одинаковых Pod'ов`. Настраивая Deploy unit, следует указать самое большое количество параметров: изоляцию подов по сети, дата центры, ресурсы, диски, политику деплоя, настройки агентов, мониторингов и логов. Также на уровне Deploy Unit [задаются секреты](how-to/secrets.md) и настройки для доступа к другим сервисам через TVM.

Логически связанные Deploy Unit можно объединить на верхнем уровне в сущности [Stage (Стейдж)](concepts/stage/stage.md). Это группа Deploy Unit, выкладка которых оркестрируется между собой. Служит, например, для разделения окружений (testing, pre-stable, stable) или объединения разных, но связанных логически Deploy unit (backend + frontend).

Сущностью самого верхнего уровня является [Project (Проект)](concepts/project.md). Она служит для логического разделения сервисов между собой, группировки нескольких Stage. На этом уровне указываются связь с ABC-сервисом и выдача [квот](reference/quotas-and-limits.md) на ресурсы, а также указание [ролей](reference/access-management/rbac.md) на все стейджи проекта.

Например, в один проект могут входить 3 стейджа для фронтенда (test/pre/prod) и 3 стейджа для бэкенда (test/pre/prod). Возможная организации проекта представлена в разделе [Руководство по запуску сервиса](launch/index.md#project-sample).

Подробнее об иерархии сущностей в Y.Deploy можно почитать [тут](concepts/entity-hierarchy.md).

## Создайте Project и Stage {#project-stage}

Чтобы создать Project и Stage, а также настроить связь с ABC-сервисом:

1. В [консоли управления Y.Deploy](https://deploy.yandex-team.ru) в правом верхнем углу нажмите **Create new project**.
2. В открывшемся окне укажите следующие параметры:
    * В поле **Project Name** введите название создаваемого [проекта](concepts/project.md), например `servicename-prod`. Название проекта нельзя изменить после создания.
    * В **ABC Service** укажите ABC сервис, [квоты](https://rtc.yandex-team.ru/docs/quotas) которого будут использованы для создания сервиса. Выбранная квота будет использоваться для всех стейджей в созданном проекте.
3. Для создания проекта нажмите кнопку **Save**. Y.Deploy начнёт создание проекта, вы можете наблюдать за этим процессом на открывшейся странице.
4. Создайте новый [Stage](concepts/stage/stage.md), нажав кнопку **Create new Stage**.
5. Придумайте и введите **Stage ID** — уникальный идентификатор стейджа.

    {% note alert %}
    
    Все стейджи живут в одном общем пространстве имён, поэтому называть их следует наиболее полно и осознанно. Например: `servicename-production-deploy-backend-..`.
    
    {% endnote %}

Идентификатор проекта **Project ID** будет выбран автоматически при создании стейджа. Все остальные параметры можно оставить без изменений — будут использоваться значения по умолчанию.

## Настройте Deploy Unit {#deploy-unit}

При создании Stage'а будет автоматически добавлен Deploy Unit. В данном сценарии достаточно одного Deploy Unit, для его настройки:

1. В левой части экрана выберите ![deploy-unit-icon](_assets/icons/deploy-unit.png) **DeployUnit** и укажите:

    * Введите в поле **Deploy unit ID** — уникальный идентификатор Deploy unit, например `prod-service-websearch`.
    * При необходимости в поле **Runtime version** выберите [версию runtime](reference/patchers-revision.md) Y.Deploy. Для данного сценария можно оставить без изменений.

2. Для настройки сети в блоке **Network Settings** в поле **Network ID** выберите доступный вам сетевой макрос .
    
    {% note info %}

    Проектная сеть, в которой будут запущен ваш сервис. ([Как создать новый project id / сетевой макрос](https://rtc.yandex-team.ru/docs/network/project-id)).
    Можно указать только сеть, к которой у текущего пользователя есть доступ
    Список доступных себе сетей: [https://racktables.yandex-team.ru/index.php?page=services&tab=vperms](https://racktables.yandex-team.ru/index.php?page=services&tab=vperms)
    Доступы до конкретной сети: [https://racktables.yandex-team.ru/index.php?page=services&tab=vperms#fws-SEARCHSAND](https://racktables.yandex-team.ru/index.php?page=services&tab=vperms#fws-SEARCHSAND)
    Редактировать доступы могут владельцы сети - со страницы вроде [https://racktables.yandex-team.ru/index.php?page=services&tab=vperms#fws-SEARCHSAND](https://racktables.yandex-team.ru/index.php?page=services&tab=vperms#fws-SEARCHSAND)
    При создании новой сети галочку **Выделить сеть (project id)** оставляем включённой.

    {% endnote %}

3. В блоке **Location policy**:

    * Выберите [примитив деплоя](concepts/deploy-unit/deploy-primitives.md) **Deploy unit type**: `Per-Cluster replica set` для управления набором Pod отдельно для каждой локации.
    * Укажите **Location** — локацию, в которых будет запущен ваш сервис. Можно оставить по умолчанию `SAS`.
    * Задайте количество подов в выбранной локации **Pods quantity** — `1` и количество Pod, которые могут быть недоступны [Disruption Budget](concepts/deploy-unit/deploy-primitives#disruption-budget.md) — `1`.

4. В блоке **Per pod settings** настройте вычислительные ресурсы, которые будут выделены каждому инстансу вашего микросервиса:

    * уровень производительности **CPU** — `100` vCPU. Этот уровень определяет долю вычислительного времени физических ядер, которую гарантирует vCPU.
    * Количество памяти **RAM** — `1` GB.
    * [Anonymous memory limit](concepts/pod/pod#anonymous-memory-limit.md) в данном сценарии оставьте пустым. По умолчанию будет зарезервировано 128Mb под кеш.
    * Гарантированную скорость сетевого соединения **Network bandwidth guarantee**: `10 MB/s`. 

5. Перейдите на вкладку **Disk, volumes, and resources** и укажите следующие настройки:

    * Ттип диска **Type** — `HDD`.
    * Размер диска **Size** — `3 GB`.
    * Гарантированная пропуская способность **Bandwidth guarantee**: `10 MB/s`.
    * **Bandwidth limit** — оставьте включенной опцию `Use default bandwidth limit`.

Далее убедитесь, что в блоке **Layer** уже добавлены [слои](concepts/pod/podagentpayload/resources/layer.md): Ubuntu Xenial и слой `simple_http_server`. Слой с simple_http_server — это тестовый слой, который содержит простейший htpp-сервер для знакомства с сервисом. Для будущих ваших проектов он не понадобится, так как вы будете запускать своё приложение, приносимое другими слоями или ресурсами.

Все остальные параметры для Deploy Unit оставьте без изменений.

## Настройте Box и Workload {#box-workload}

Далее настройте Box — это "подконтейнер" внутри Deploy Unit, где указываются сетевые настройки, ограничения по ресурсам, общие для Workload переменные окружения, базовые слои вашего приложения (docker/porto), статические и динамические ресурсы. Другими словами, именно в Box будут определены файлы, запуск которых происходит в Workload.

1. В левой части экрана выберите ![box-icon](_assets/icons/box.png) **Box**.
2. Задайте идентификатор **Box ID**: `nginx`. Остальные настройки оставьте без изменений.
3. Чтобы настроить ворклоад в левой части экрана выберите ![workload-icon](_assets/icons/workload.png) **Workload** и укажите следующие параметры:

    * Идентификатор ворклоада **Workload ID**: `nginx-ext`.
    * Включите логирование **Logs**: `Enabled`.

3. Убедитесь, что в блоке **Commands and presets** уже указана стартовая команда **Start command** для запуска http-сервера на 80 порту: `/simple_http_server 80 'Hello my dear @username@'`. 

## Запустите деплой сервиса {#deploy}

Теперь всё готово для запуска сервиса. 

1. Нажмите кнопку **Create** в правом верхнем углу. На экране отобразится yaml спецификация, которая содержит все настройки, указанные ранее в UI Y.Deploy.
2. Чтобы начать деплой сервиса в нижней части экрана нажмите кнопку **Deploy**.

На экране отобразиться процесс создания ресурсов. Дождитесь завершения выкатки — Pod перейдёт в статус `Started`.

После запуска приложения на вкладке **Monitoring** вам будут доступны базовые [панели мониторинга](reference/monitorings/panels). Подробнее о настройке сбора метрик и настройке отправки событий [Настройка мониторингов в Deploy](launch/monitorings.md)

На вкладке **Logs** отображаются [логи приложения](concepts/pod/sidecars/logs/logs.md), а на вкладке **History** доступна история [ревизий](concepts/stage/stage.md#pro-revizii). 

Вы также можете создать балансировщик и настроить [балансировку](launch/balancing.md) над поднятыми подами.

## Протестируйте работу сервиса {#test}

Чтобы протестировать работу созданного веб-сервера необходим сетевой доступ.

1. Дождитесь завершения выкатки — Pod перейдёт в статус `Started`.
2. Скопируйте FQDN пода и протестируйте работу веб-сервера, открыв в браузере сайт по адресу  `....sas.yp-c.yandex.net`

## См. также {#seealso}

* [Настройка CI/CD](launch/ci-cd.md)
* [{#T}](launch/logs.md)
* [Запуск сервиса в безопасном окружении](launch/sox-service.md)
