# Политика доступа к API Y.Deploy

Deploy использует YP как метабазу. Соотвественно API Deploy представлены в виде объектов в YP.
Доступ к API есть, но он ограничен. Мы это делаем для того, чтобы понимать, какие системы и как будут строить автоматизацию поверх нашего API, для этого введен процесс описанный ниже.

## Политика доступа по умолчанию

В контексте доступа к API существует 3 вида прав:

* на создание объектов - CREATE
* на модификацию - WRITE
* на чтение - READ

Всем ****роботам**** открыт доступ только на ****READ**** всех объектов, кроме секретов.
Всем пользователям открыт доступ:

* на READ всех объектов, кроме секретов
* на CREATE всех "публичных" объектов
* на WRITE своих "публичных" объектов (где под своими мы подразумеваем объекты доступ к которым выдан через [ролевую модель Y.Deploy](rbac.md))

Что это означает для пользователя: все пользователи могут от своего имени заводить новые Stage, модифицировать их и удалять. Также ****от своего имени****, используя утилиту dctl, или напрямую ходя в YP API, запускать скрипты для простой автоматизации рутинных операций. Например, выкладки тестового сервиса на основе локального билда. Использование API для более сложной автоматизации, должно быть согласовано.

## Как получить доступ к API для более сложной автоматизации {#how-to-get-access}

Заявки на использование API для более сложной автоматизации принимаются через [форму](https://forms.yandex-team.ru/surveys/24997/).

Мы хотим знать:

* Для каких целей будет использоваться
* Какая квота по RPS необходима
* Какая квота на количество одновременно созданных объектов Stage,Pod необходима.
* Какой паттерн нагрузки предвидится.

## Сценарии CI/CD
Часто API в Qloud/Nanny используют для continuous integration и continuous delivery.
Основные сценарии это:

* Прокатка релизов в существующие сервисы.
* Создание сервисов "на лету".

Уже сейчас в Y.Deploy реализована механика [Релизной интеграции](../../concepts/release-integration/release-integration.md) этот функционал предназначен для автоматизации выкладки релизов на основе появившихся ресурсов.

Сценарий создания "из воздуха" тестовых контуров для прогона тестов/приемки и последующее их удаление т.н. сценарий "покоммитных бет" будет реализован в рамках интеграции Y.Deploy и The CI. Данный сценарий мы считаем валидным и для него мы согласуем доступ в API Y.Deploy с условием, перехода сервиса на инструментарий The CI когда он будет готов.
