# Ролевая модель в Y.Deploy

## Объекты {#objects}

* Проект [project](../../concepts/project.md)
* Стейдж [stage](../../concepts/stage/stage.md)
* `[Coming later]` Тип бокса [box type](#user)

## Субъекты {#subjects}

* Логин со staff'а
* Подразделение со staff'а
* ABC сервис
* Роль в рамках ABC сервиса

## Пользователи {#users}

* nobody: имеет доступ в контейнер, может читать и писать файлы которые доступны для чтения и записи всем (см. chmod 777), может посмотреть запущенные процессы, не имеет дополнительных capabilities.
* root: имеет доступ в контейнер, может читать и писать все файлы, может влиять на процессы, имеет capabilities: 'SETUID', 'SETGID',  'AUDIT_WRITE','CHOWN','DAC_OVERRIDE','FOWNER','NET_ADMIN', 'NET_BIND_SERVICE''SYS_PTRACE', 'KILL'

## Роли {#roles}

* **`SUPER_USER`**:
    - может подтверждать и отзывать любую роль для любого объекта

* **`OWNER`:**
    - роль выдается только на проект
    - может просматривать спецификацию проекта и его стейджей
    - может подтверждать любые роли, выданные на проект, включая роль `OWNER`, или на его стейджи
    - может удалить проект (но только если удалены все стейджи)
    - может создавать новые стейджи для этого проекта
    - может редактировать любые стейджи в проекте (и выкатывать изменения)
    - может удалить существующие стейджи в этом проекте
    - имеет доступ по SSH во все контейнеры пользовательских боксов всех стейджей этого проекта, как пользователь `root` или `nobody`

* **`MAINTAINER`:**
    - роль выдается на весь проект или конкретный стейдж
    - при выдаче на проект:
        - может просматривать спецификацию проекта и его стейджей
        - может подтверждать роль `VIEWER`, выданную на проект или на его стейджи
        - может создавать новые стейджи для этого проекта
        - может редактировать любые стейджи в проекте (и выкатывать изменения)
        - может удалить существующие стейджи в этом проекте
        - может создавать релизные тикеты
        - имеет доступ по SSH во все контейнеры пользовательских боксов всех стейджей этого проекта, как пользователь `root` или `nobody`
    - при выдаче на конкретный стейдж:
        - может просматривать спецификацию стейджа
        - может подтверждать роль `VIEWER`, выданную на стейдж
        - может редактировать этот стейдж (и выкатывать изменения)
        - может удалить этот стейдж
        - имеет доступ по SSH во все контейнеры пользовательских боксов этого стейджа, как пользователь `root` или `nobody`

* **`ROOT_DEVELOPER`:**
    - роль выдается на весь проект или конкретный стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проекта и его стейджей
        - имеет доступ по SSH во все контейнеры пользовательских боксов всех стейджей этого проекта, как пользователь `root` или `nobody`
    - при выдаче на конкретный стейдж:
        - позволяет просматривать спецификацию стейджа
        - имеет доступ по SSH во все контейнеры пользовательских боксов этого стейджа, как пользователь `root` или `nobody`

* **`DEVELOPER`:**
    - роль выдается на весь проект или конкретный стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проекта и его стейджей
        - имеет доступ по SSH во все контейнеры пользовательских боксов всех стейджей этого проекта, как пользователь `nobody`
    - при выдаче на конкретный стейдж:
        - позволяет просматривать спецификацию стейджа
        - имеет доступ по SSH во все контейнеры пользовательских боксов этого стейджа, как пользователь `nobody`

* **`SYSTEM_DEVELOPER`:**
    - служебная роль выдается на весь проект или конкретный стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проекта и его стейджей
        - имеет доступ по SSH во все контейнеры системных боксов (tvm, unified agent) и подов всех стейджей этого проекта, как пользователь `root` или `nobody`
    - при выдаче на конкретный стейдж:
        - позволяет просматривать спецификацию стейджа
        - имеет доступ по SSH во все контейнеры системных боксов (tvm, unified agent) и подов этого стейджа, как пользователь `root` или `nobody`

* **`APPROVER`:**
    - роль выдается на весь проект или конкретный стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проекта и его стейджей
        - позволяет подтверждать деплой любого стейджа в рамках [релизной интеграции](../../concepts/release-integration/release-integration.md)
    - при выдаче на конкретный стейдж:
        - позволяет просматривать спецификацию стейджа
        - позволяет подтверждать деплой этого стейджа в рамках [релизной интеграции](../../concepts/release-integration/release-integration.md)

* **`MANDATORY_APPROVER`:**
    - роль выдается на весь проект или конкретный стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проекта и его стейджей
        - позволяет основному подтверждающему разрешать деплой любого стейджа в рамках [релизной интеграции](../../concepts/release-integration/release-integration.md)
    - при выдаче на конкретный стейдж:
        - позволяет просматривать спецификацию стейджа
        - позволяет основному подтверждающему разрешать деплой этого стейджа в рамках [релизной интеграции](../../concepts/release-integration/release-integration.md)

* **`DEPLOYER`:**
    - роль выдается на проект
    - может подтверждать роль `VIEWER`, выданную на проект или на его стейджи
    - позволяет просматривать спецификацию проекта и его стейджей
    - позволяет редактировать стейджи этого проекта (выкатывать/откатывать изменения), без возможности создавать новые или удалять старые, а также не предоставляет доступ в боксы.

* **`RESPONSIBLE`:**
    - роль выдается на проект или стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проект и его стейджей
        - позволяет определять ответственных за стейджи проекта для различных оповещений/подтверждений
    - при выдаче на стейдж:
        - позволяет просматривать спецификацию стейджа
        - позволяет определять ответственных за этот стейджи для различных оповещений/подтверждений
    - в будущем эта роль станет обязательной для всех стейджей
    - ответственные будут определяться из *RESPONSIBLE of stage *или *RESPONSIBLE of project*.
    Если эти роли будут не заданы, то ответственные будут определяться по следующей цепочке, пока не найдутся люди на одном из шагов:
    MAINTAINER of stage **->** login from /meta/owner_id in project **->** OWNER of project **->** MAINTAINER of project.

* **`VIEWER`:**
    - роль выдается на проект или стейдж
    - при выдаче на проект:
        - позволяет просматривать спецификацию проект и его стейджей
    - при выдаче на стейдж:
        - позволяет просматривать спецификацию стейджа


{% note info %}

Пользователи с ролями OWNER, DEPLOYER, MAINTAINER (ролями, которые могут осуществлять выкладки)
должны иметь доступ до сетевых макросов использующихся в каждом из DeployUnit данного stage

{% endnote %}



## Доступ в контейнеры боксов и подов по SSH {#ssh}
Доступ в пользовательские боксы:
* если ты `ROOT_DEVELOPER`, то по своему ключу можешь войти любым пользователем (при наличии его в контейнере)
* если ты `DEVELOPER`, то по своему ключу можешь войти пользователем nobody@
* если ты пользователь `X`, имеющий роль `DEVELOPER`, то по ключу пользователя `X` можно войти пользователем `X` (при наличии его в контейнере).
* SSH команды выглядят так:
`ssh root@box_ip` - можно делать в контейнере всё
`ssh nobody@box_ip` - только "посмотреть логи"
`ssh user_name@box_ip` - при наличии в системе пользователя `user_name` сможет то, что разрешено этому пользователю
`ssh box_ip` - аналогично `user_name@box_id`


Доступ в под и системные боксы:
* если ты `SYSTEM_DEVELOPER`, то по своему ключу можешь войти любым пользователем (при наличии его в контейнере)
* SSH команды аналогичны доступу в пользовательские боксы, кроме доступа в под. В этом случае вместо IP бокса необходимо указать FQDN пода

## Права на подтверждение и отзыв ролей в IDM {#idm}

Роль `SUPER_USER` может быть подтверждена только другим `SUPER_USER`'ом

Роли `OWNER`, `MAINTAINER`, `ROOT_DEVELOPER`, `DEVELOPER`, `APPROVER`, `MANDATORY_APPROVER`, `DEPLOYER`, `RESPONSIBLE` могут быть подтверждены `OWNER`'ами проекта или `SUPER_USER`'ами

Роль `SYSTEM_DEVELOPER` может быть подтверждена только `SUPER_USER`'ами

Роль `VIEWER` может быть подтверждена только `OWNER`'ами, `MAINTAINER`'ами или `DEPLOYER`'ами

Роль `SUPER_USER` может быть отозвана `SUPER_USER`'ами или, если роль выдана на человека, то его руководителем и выше по иерархии стаффа

Роли `OWNER`, `MAINTAINER`, `ROOT_DEVELOPER`, `DEVELOPER`, `APPROVER`, `MANDATORY_APPROVER`, `DEPLOYER`, `RESPONSIBLE` могут быть отозваны `OWNER`'ами проекта, `SUPER_USER`'ами или, если роль выдана на человека, то его руководителем и выше по иерархии стаффа

Роль `SYSTEM_DEVELOPER` может быть отозвана `SUPER_USER`'ами или, если роль выдана на человека, то его руководителем и выше по иерархии стаффа

Роль `VIEWER` может быть отозвана `OWNER`'ами, `MAINTAINER`'ами, `DEPLOYER`'ами или, если роль выдана на человека, то его руководителем и выше по иерархии стаффа

## Автоматическая выдача/отзыв ролей роботом {#auto}

Y.Deploy автоматически выдает два типа ролей:

- `SUPER_USER` - выдается всем `Подтверждающим` в сервисе [Я.Деплой Управление Доступом](https://abc.yandex-team.ru/services/ydeployaccesscontrol/)
- `OWNER` - выдается на пользователя создавшего проект

По удалению ролей работает следующая автоматика:

- при удалении стейджа (или переносе его в другой проект) автоматически отзываются все роли, выданные на этот стейдж
- при удалении проекта автоматически удаляются все роли, выданные на этот проект (проект нельзя удалить, если в нем существует хотя бы один стейдж)

{% note info %}

Из-за особенностей функционирования IDM не рекомендуется удалять проект и создавать новый с таким же именем в течении **15 минут** после удаления, так как это приведет к тому, что роль `OWNER` на новый проект не будет выдана. Тикет на исправление - [https://st.yandex-team.ru/IDM-9552](https://st.yandex-team.ru/IDM-9552)

{% endnote %}

## Миграция на новую ролевую модель {#migration}

В старой модели при создании стейджа выдавались все права на стейдж пользователю, который создал, плюс иногда на весь ABC сервис, указанный в этом стейдже. Это работало для стейджей созданных и через GUI и через dctl.

В новой модели роли будут выдаваться исключительно через IDM, соответственно будут сделаны следующие изменения:

- будут удалены ранее выданные роль с полным доступом:
- пользователям будет дано время на то, чтобы выдать необходимые роли через IDM
- перед удалением данных ролей будет дополнительное оповещение
- не будет возможности самостоятельно записать что-либо в meta.acl, ACL будут меняться исключительно нашим роботом
- это будет сделано в ближайшее время, с предварительным анонсом

Побочные эффекты на время миграции:

- старые роли не будут видны на странице проектов, увидеть их можно только в таблице Stage в YP (XDC)
- соответственно будет не очевидно, доступ есть из-за выданной новой роли или из-за старой, поэтому, пожалуйста, внимательно ознакомьтесь с новой ролевой моделью и заранее запросите необходимые роли.
- отзыв ролей через IDM не будет работать для старых ролей, так как для IDM они не известны
- сейчас автоматически выданы роли `OWNER` на все проекты, автоматика не учитывала некоторые моменты и возможно, что `OWNER` выбран неверно, поэтому запросите роль на правильных людей/группу/сервис через IDM, после этого вы сможете удалить лишние роли и добавить новые самостоятельно
- сейчас помимо автоматически выданных ролей `OWNER` на проект, также выданы роли `MAINTAINER` на некоторые стейджи (это отголоски автоматической миграции), такие роли вы сможете удалить напрямую в IDM или через новую страницу проекта (если вы являетесь `OWNER`'ом проекта)

## User specific типы боксов {#user}

{% note info %}

данная функциональность находится на финальной стадии разработки

{% endnote %}

Данная функциональность реализована для более гранулярной выдачи доступа по SSH в боксы Я.Деплоя. Особенно это актуально, например, для SOX сервисов, чтобы отделить доступ в боксы с критичными данными.

Боксы бывают трех типов:

- обычные (`default`):
    - для доступа к ним должна быть выдана роль `DEVELOPER` или `ROOT_DEVELOPER` на стейдж или проект
    - это обычный тип, устанавливаемый по умолчанию на все пользовательские боксы
- системные (`system`):
    - для доступа к ним должна быть выдана роль `SYSTEM_DEVELOPER` на стейдж или проект
    - данный тип устанавливается самой системой на определенный набор служебных боксов (logbroker, tvm)
- специальные (`user specific`):
    - этот тип задается пользователем на странице редактирования проекта
    тут будет картинка про редактирование проекта
    - специальные типы привязываются к проекту и могут быть использованы во всех стейджах данного проекта
    - в проекте может быть более одного специального типа
    - назначение специального типа на боксы осуществляется на странице создания/редактирования стейджда
    тут будет картинка про навешивание типа на бокс на форме редактирования стейджа
    - для доступа в такие боксы необходима роль `DEVELOPER` или `ROOT_DEVELOPER` на конкретный стейдж и тип бокса, то есть нельзя выдать такую роль на все типы специальных боксов и на весь проект
