# Replica Set Controller

Replica Set Controller (далее — RSC) приводит набор одинаковых Pod (Replica Set) к [целевому состоянию](#target-state).

##  Целевое состояние Replica Set {#target-state}

Целевое состояние описывается в спецификации Replica Set (далее — RS) и определяет количество Pod и их ревизии в наборе.

Применение механизмов [перехода в целевое состояние](#ts-maintenance) зависит от [типа RSC](#rsc-types).

Пример спецификации в формате yaml:

```yaml
spec:
  account_id: tmp
  constraints:
    antiaffinity_constraints:
    - key: rack
      max_pods: 1
  node_segment_id: ''
  deployment_strategy:
    max_unavailable: 3
    deploy_speed:
      update_portion: 2
      min_delay: 30
  pod_template_spec:
    spec: ...
    labels:
      rs: ...
  replica_count: 9
  revision_id: '8'
```

- `account_id` — источник квоты. ABC-аккаунт или tmp.
- `constraints` — на данный момент содержит только настройки [Antiaffinity](https://a.yandex-team.ru/arc/trunk/arcadia/yp/client/api/proto/data_model.proto?rev=6495329#L111).
- `node_segment_id` — `default`. Идентификатор сегмента физической топологии. Не изменяется пользователем.
- `deployment_strategy` —  параметры управления деплоем. Поле `max_unavailable` соответствует заданному пользователем [Disruption budget](../../../concepts/deploy-unit/deploy-primitives.md#disruption-budget).
- `deployment_strategy.deploy_speed`. Задаёт скорость, с которой можно обновить `max_unavailable` подов. `deploy_speed.update_portion` - это количество Подов, которые RSC может обновлять каждые `deploy_speed.min_delay` секунд (возможно реже, но точно не чаще). При этом RSC будет учитывать, чтобы количество недоступных подов не было больше, чем `deployment_strategy.max_unavailable`. В примере выше RSC обновит только 2 Пода. Допустим, Поды поднимаются в течении 60 секунд. Тогда по прошествии ~ 30 секунд (возможно больше, но точно не меньше) RSC обновит ещё 1 Под.
- `pod_template_spec` — содержит спецификацию пода (поле `spec`) и лейблы (поле `labels`).
  * `spec` - спецификация Pod должна удовлетворять следующей [схеме](https://a.yandex-team.ru/arc/trunk/arcadia/yp/client/api/proto/data_model.proto?rev=6495329#L950). При создании Pod,  RSC принудительно переписывает поле `enable_scheduling` в `True`.
  * `labels` - лейблы, которые будут записаны во все Pod'ы данного Replica Set. Все лейблы рекомендуется указывать в родительском лейбле `rs`. Это необходимо, чтобы исключить клэш лейблов, которые задаёт RSC с лейблами, которые пользователь указывает вручную.
- `replica_count` — количество Pod в RS.
- `revision_id` — идентификатор ревизии. Инкрементально увеличивается при каждом обновлении спецификации RS. Не изменяется пользователем.

##  Типы RSC {#rsc-types}

- Cluster RSC (CRSC). Реализует [примитив деплоя](../../../concepts/deploy-unit/deploy-primitives.md) Per Cluster.
- Multi-Cluster RSC (MCRSC). Реализует примитив деплоя Multicluster.

##  Переход к целевому состоянию {#ts-maintenance}

###  Replica Set {#tsm-replica-set}

В целевом состоянии RS должeн содержать заданное в спецификации количество Pod, соответствующих последней ревизии спецификации. Для этого RSC cледит за количеством работоспособных Pod и производит их деплой и [эвакуацию](#eviction).

При необходимости пользователь может [приостановить](../../../how-to/deploy-speed.md) работу RSC.

###  Pod {#tsm-pod}

RSC следит за тем, чтобы все Pod соответствовали последней ревизии спецификации.

Приведение Pod к целевому состоянию назовём **деплой**.

Правила деплоя:

- RSC пропускает все промежуточные состояния между текущим и целевым состоянием Pod и сразу приводит Pod  к целевому состоянию.
- Порядок обновления Pod RSC выбирает автоматически, пользователь не может на это влиять ([Rolling update](#rolling-update)).
- По возможности, RSC старается применить [Inplace update](#inplace-update), т.е. обновляет Pod без пересоздания.

## Удаление подов {#remove-pods}
RSC всегда удаляет поды **gracefully**. То есть поды сначала полностью выключаются и только после полного выключения удаляются. **Если выключение не случается за 30 минут, то поды удаляются форсированно, не дожидаясь выключения**.

## Группировка подов {#group-pods}
Контроллер разделяет поды на несколько групп.

* **Ready**: живые поды, которые можно обновлять, и они не съедают бюджет.
* **InProgress**: поды в процессе обновления. Они съедают бюджет.
* **Failed**: поды, у которых случились проблемы с обновлением. Они съедают бюджет.
* **MarkedRemove**: поды, помеченные для удаления. Эти поды либо в процессе выключения, либо уже выключились. Съедают бюджет.

##  Механизмы RSC {#deploy-mechanics}

###  Rolling update {#rolling-update}

RSC приводит Pod к целевому состоянию последовательно. Порядок обработки подов выбирается RSC, пользователь не может управлять им.

Параметры обновления:

- `deployment_strategy.max_unavailable` — максимальное количество подов, которые могут быть недоступны в Replica Set.
- `deployment_strategy.min_available` — не используется.
- `deployment_strategy.max_surge` — не используется.

**Важно помнить**, что RSC первым делом приводит количество подов к `replica_count`. Это действие RSC выполняет **без бюджета**, т.е. сразу удаляет или создаёт поды, таким образом, чтобы их количество стало равным `replica_count`. Только после этого RSC начинает обновлять поды, и это он делает окном по `deployment_strategy.max_unavailable` подов.

###  Inplace update {#inplace-update}

Обновление спецификации Pod может приводить к пересозданию Pod (удаление и создание с новыми id) или без него. Обновление Pod без пересоздания называется //inplace update//.

Пересоздание длится дольше, чем inplace update, так как содержит больше стадий. Пересоздание обычно происходит в том случае, когда текущая Node не соответствует обновлённой спецификации Pod, например, из-за требований к аппаратным ресурсам.

Пересоздание происходит, когда в спецификации Pod меняется один из ресурсов:

- `resource_requests`
- `disk_volume_requests`
- `ip6_address_requests`
- `host_devices`

Случае изменения Box или Workload применяется inplace update.


###  Эвакуация {#eviction}

Эвакуация — это перемещение Pod внутри физической топологии.

Перемещение происходит, если Pod неработоспособен по одной из следующих причин:

- проблемы с оборудованием на ноде (involuntary disruption)
- сетевые проблемы на ноде (involuntary disruption)
- kernel panic (involuntary disruption)
- уплотнение кластера руками администратора (voluntary disruption)

Эвакуация имеет более высокий приоритет, чем деплой. Т.е. деплой не начнётся до тех пор, пока не завершится эвакуация, если эти два процесса происходят одновременно.

При эвакуации учитывается `deployment_strategy.max_unavailable`.

### Порядок удаления подов {#remove-order}
RSC удаляет поды, когда `replica_count` в спеке RS меньше, чем реальное количество подов. При удалении подов контроллер должен отсортировать поды в порядке приоритета на удаление. Приоритет строится следующим образом:

1. MarkedRemove (поды уже помечены для удаления, есть смысл начать удаление с них)
2. Поды с запрошенным эвикшеном
3. Failed-поды не в целевой ревизии
4. InProgress-поды не в целевой ревизии
5. Ready-поды не в целевой ревизии
6. Failed-поды в целевой ревизии
7. InProgress-поды в целевой ревизии
8. Ready-поды в целевой ревизии

### Порядок обновления подов {#update-order}
Обновление подов - это деструктивная операция. Поэтому поды хотелось бы обновлять в таком порядке, чтобы окно деградации уменьшалось минимально. Приоритет обновления такой:

1. MarkedRemove не в целевой ревизии
2. Поды с запрошенным эвикшеном не в целевой ревизии
3. Failed-поды не в целевой ревизии
4. InProgress-поды не в целевой ревизии
5. Ready-поды не в целевой ревизии
