# Квоты, лимиты и гарантии

В сервисах QYP, Y.Deploy и RTC действуют следующие понятия:

* _Гарантии_ — это указание для YP сколько ресурсов необходимо поду, чтобы планировщик селил этот под на кластере.
* _Лимиты_ — ограничение по ресурсам (планировщик о нём не знает). Лимит не используется при планировании, но на ноде ограничивает поды по ресурсам.
* _Квота_ — это общий объем всей гарантии, который может получить ABC-сервис в указанном ДЦ.

## Квоты {#quotas}

Для запуска приложения в Y.Deploy требуется [YP-квота](https://rtc.yandex-team.ru/docs/quotas).

Существует 3 вида квот:

* **tmp-квота**, которую можно использовать только для знакомства с Y.Deploy. Данной квотой могут воспользоваться __только__ люди (у роботов такой возможности нет). Подробнее про tmp-квоту читайте в [документации YP](https://wiki.yandex-team.ru/yp/quotas/).
Не путайте tmp-квоту со [временной квотой под переезд сервиса](../how-to/migration/qloud/quota.md).
* [Free Tier квота](https://wiki.yandex-team.ru/ftq/yp/) — это квота в YP, которую можно получить новому сервису, без необходимости длительных согласований и заказов. Основная цель состоит в том, чтобы новые сервисы и проекты могли запускаться быстро и без лишних формальностей получать ресурсы. Отличие от tmp-квоты — в данной квоте можно запускать **Production** сервисы, квота выдается на более длительный срок, отсутствуют риски, что эту квоты полностью займет какой-то другой "экспериментатор".
* **Постоянная квота**, выданная на ABC сервис.

В квоту на момент написания статьи входят следующие классы ресурсов:

* CPU
* RAM
* HDD Capacity и I/O
* SSD Capacity и I/O
* GPU (на данный момент данную квоту нельзя использовать в Y.Deploy)
* Network bandwidth
* Зарезервированные ipv4 адреса

### Где посмотреть?

Посмотреть текущее потребление квоты можно в графическом интерфейсе **QYP** в разделе [Quota](https://qyp.yandex-team.ru/quota) и в Y.Deploy в разделе [YP Quotas](https://deploy.yandex-team.ru/quotas) (квоты общие для всех систем).

Наблюдать потребление ресурсов сервисом можно в Y.Deploy. на странице стейджа во вкладке **Monitoring**. 


{% cut "Посмотреть текущее потребление квоты с помощью ya tools yp-util:" %}

Использование квоты по ABC-сервису можно посмотреть так:

```bash
$ ya tools yp-util account explain abc:service:ID --cluster sas
```
* В качестве кластеров можно указать `sas`, `man`, `vla`, `iva`, `myt`.
* `ID` — ABC сервиса, можно найти на его странице.

Результат:

```
Account(s) limits:
╒═══════╤═══════════╤═════════════════╤════════╤════════════╤══════════╤══════════╤════════════╤════════╤════════════╤════════╤════════════╕
│       │ segment   │ account_id      │ slug   │ vcpu       │ memory   │ hdd      │ hdd_bw     │ ssd    │ ssd_bw     │   ipv4 │ net_bw     │
╞═══════╪═══════════╪═════════════════╪════════╪════════════╪══════════╪══════════╪════════════╪════════╪════════════╪════════╪════════════╡
│ 0     │ default   │ abc:service:729 │ Wall-E │ 86.0 cores │ 204.0 Gb │ 921.6 Gb │ 639.0 Mb/s │ 1.1 Tb │ 219.0 Mb/s │      0 │ 2.305 Gb/s │
├───────┼───────────┼─────────────────┼────────┼────────────┼──────────┼──────────┼────────────┼────────┼────────────┼────────┼────────────┤
│ total │           │                 │        │ 86.0 cores │ 204.0 Gb │ 921.6 Gb │ 639.0 Mb/s │ 1.1 Tb │ 219.0 Mb/s │      0 │ 2.305 Gb/s │
╘═══════╧═══════════╧═════════════════╧════════╧════════════╧══════════╧══════════╧════════════╧════════╧════════════╧════════╧════════════╛

Account(s) usages:
╒═══════╤═══════════╤═════════════════╤════════╤═════════════╤════════════╤════════════╤════════════╤═════════╤═══════════╤════════╤════════════╕
│       │ segment   │ account_id      │ slug   │ vcpu        │ memory     │ hdd        │ hdd_bw     │ ssd     │ ssd_bw    │   ipv4 │ net_bw     │
╞═══════╪═══════════╪═════════════════╪════════╪═════════════╪════════════╪════════════╪════════════╪═════════╪═══════════╪════════╪════════════╡
│ 0     │ default   │ abc:service:729 │ Wall-E │ 78.19 cores │ 167.344 Gb │ 893.133 Gb │ 600.0 Mb/s │ 40.0 Gb │ 70.0 Mb/s │      0 │ 550.0 Mb/s │
├───────┼───────────┼─────────────────┼────────┼─────────────┼────────────┼────────────┼────────────┼─────────┼───────────┼────────┼────────────┤
│ total │           │                 │        │ 78.19 cores │ 167.344 Gb │ 893.133 Gb │ 600.0 Mb/s │ 40.0 Gb │ 70.0 Mb/s │      0 │ 550.0 Mb/s │
╘═══════╧═══════════╧═════════════════╧════════╧═════════════╧════════════╧════════════╧════════════╧═════════╧═══════════╧════════╧════════════╛

Pod set(s) usages:
╒═══════╤═══════════╤═════════════════╤═══════════════════════════════════════════╤═════════════╤════════════╤════════════╤════════════╤═════════╤═══════════╤════════╤════════════╕
│       │ segment   │ account_id      │ pod_set_id                                │ vcpu        │ memory     │ hdd        │ hdd_bw     │ ssd     │ ssd_bw    │   ipv4 │ net_bw     │
╞═══════╪═══════════╪═════════════════╪═══════════════════════════════════════════╪═════════════╪════════════╪════════════╪════════════╪═════════╪═══════════╪════════╪════════════╡
│ 0     │ default   │ abc:service:729 │ production-wall-e-api-yp                  │ 6.0 cores   │ 29.297 Gb  │ 117.188 Gb │ 90.0 Mb/s  │ 0.0 b   │ 0.0 b/s   │      0 │ 0.0 b/s    │
├───────┼───────────┼─────────────────┼───────────────────────────────────────────┼─────────────┼────────────┼────────────┼────────────┼─────────┼───────────┼────────┼────────────┤
│ total │           │                 │                                           │ 78.19 cores │ 167.344 Gb │ 893.133 Gb │ 600.0 Mb/s │ 40.0 Gb │ 70.0 Mb/s │      0 │ 550.0 Mb/s │
╘═══════╧═══════════╧═════════════════╧═══════════════════════════════════════════╧═════════════╧════════════╧════════════╧════════════╧═════════╧═══════════╧════════╧════════════╛
```

{% endcut %}

Постоянная квота в YP выдается на ABC-сервис. Квота привязана к ДЦ — нельзя использовать квоту во VLA для запуска подов в SAS. Для запуска подов стейджа используется квота ABC-сервиса, указанного в проекте к которому относится данный стейдж.

Конфигурируя стейдж, вы указываете какое количество вычислительных ресурсов разного типа требуется для работы вашего приложения. При этом, к вашему заказу **будут добавлены** ресурсы, требуемые для запуска инфраструктурного сайдкара (PodAgent). Кроме того, к этому заказу **могут быть добавлены** ресурсы, необходимые для запуска дополнительных сайдкаров, если они были выбраны при конфигурировании (например Unified Agent или TVM-Tool)

[Таблица с потреблением сайдкаров и как применяется](../concepts/pod/sidecars/sidecars.md#table)

{% note tip %}

Реальное потребление ресурсов сервисом можно наблюдать во вкладке **Monitoring** на странице стейджа в Y.Deploy.

{% endnote %}

## Сетевые лимиты и гарантии {#net-limits}

В YP можно указать сетевые _гарантии_ и _лимиты_ на сервис. Гарантия нужна для планировщика, чтобы при расселении подов на кластере, не было превышения нодами пропускной способности сети. Она не используется на самой ноде, но нужна планировщику. 
Лимит ограничивает сеть пода на ноде по входящему и исходящему трафику. Планировщик сетевые лимиты не смотрит и не использует. Подробнее см.
[clubs.at.yandex-team.ru/infra-cloud/1314](https://clubs.at.yandex-team.ru/infra-cloud/1314)

{% note warning %}

На текущий момент сетевые лимиты и гарантии в процессе внедрения. Пока вы можете создавать сервисы без NET гарантий, но в будущем эта возможность будет закрыта!

Сделать запрос на получение сетевой квоты можно через форму **Запросить квоту в YP**, которая находится в **ABC** в разделе **Квоты**.

{% endnote %}

Значения сетевых гарантий и лимитов могут быть выставлены на ваш сервис автоматически (как минимум, чтобы выдать квоту). Подобранные значения не идеальны,
поэтому далее следует [подобрать](https://clubs.at.yandex-team.ru/infra-cloud/1314), исходя из особенностей сервиса.

Реальное потребление сетевых ресурсов сервисом можно наблюдать во вкладке **Monitoring** на странице стейджа в Y.Deploy.

{% note info %}

Обратите внимание, что скорость передачи данных —  **мегабайт** в секунду (MB/s).

{% endnote %}

### FAQ сетевые квоты {#faq-net-limits}

> Есть ли графики, по которым можно за ней следить?

Наблюдать потребление сетевых ресурсов сервисом можно в Y.Deploy. на странице стейджа во вкладке **Monitoring**. 

> Если мы внезапно для себя вышли за пределы этой квоты, означает ли это деградацию всех наших сервисов под этой квотой?

Нет, не означает. Квота — это про возможность аллоцировать инстансы, исходя из потребностей по cpu, memory, disk size/bandwidth, net bandwidth. 

> Почему вылезает ошибка `id "abc:service:xxx") is over network bandwidth limit in segment` при деплое? Кажется, что нагрузка на сеть в момент деплоя - не проблема сервиса, он с этим ничего поделать не может. Если единственная возможность получить надежный деплой - это увеличить квоту, то мы ее увеличим, но получиться что для работы уже задеплоенного сервиса этой квоты будет слишком много, то есть у вас будут дутые цифры.

Потому что для аллокации инстансов нужна доступная квота. см выше. Нужно либо увеличить квоту, либо подрезать в других сервисах, которые ее используют из вашего abc-аккаунта. Опять же, вы можете отследить реальное потребление на графиках мониторинга в yasm'e. СЛедует определить насколько реально вы квоту используете в этом сервисе и, при необходимости, перераспределить из одного сервиса(стейджа) в другой.

> Откуда у меня появилась такая гарантия на моём сервисе?

Гарантии в Y.Deploy сейчас в процессе внедрения и были выставлены на ваш сервис автоматически. Подробнее см. [clubs.at.yandex-team.ru/infra-cloud/1314](clubs.at.yandex-team.ru/infra-cloud/1314)

>  вывод ya tool yp get-object account abc:service:xxx --address sas > Ты видишь тут network bandwidth 0? 
>
>
>    "network" = {
>        "bandwidth" = 0;
>    };

0 — это не безлимит, это значит что там будет столько сколько у вас есть в квоте. Если вы ее не заказывали, то там вероятно выставили дефолтные значения в 10-30 МБ/с.

> Возможно без квоты сейчас поднять стейдж?

Нужно оставить поле `networkBandwidth quarantee` пустым, а не ставить 0. Неочевидный момент, да.

## См. также {#seealso}

* [{#T}](../faq.md#quota)
* [Как перенести проект в Деплое в квоту другого ABC-сервиса](https://wiki.yandex-team.ru/market/sre/fordev/dyp/relocate-abc-quota/)
