import argparse

import infra.dctl.src.consts as consts


class ArgumentParserBuilder:
    __slots__ = ['parser']

    def __init__(self,
                 description: str):
        self.parser = argparse.ArgumentParser(description=description)

    @staticmethod
    def get_cluster_list():
        ret = []
        for cluster in consts.CLUSTER_CONFIGS.keys():
            ret.append(cluster)

        return ret

    def with_clusters(self):
        self.parser.add_argument(
            "--clusters",
            metavar="cluster",
            type=str,
            nargs="+",
            choices=ArgumentParserBuilder.get_cluster_list(),
            help="clusters to get info.",
            default=ArgumentParserBuilder.get_cluster_list()
        )

        return self

    def with_yp_token(self):
        self.parser.add_argument(
            "--token",
            dest="token",
            default=None,
            help="use specified YP token."
        )

        return self

    def build(self):
        return self.parser
