def get_labels(pod_template_spec):
    return pod_template_spec.get('labels', dict())


def get_deploy_labels(pod_template_spec):
    return get_labels(pod_template_spec) \
        .get('deploy', dict())


def get_pod_spec(pod_template_spec):
    return pod_template_spec.get('spec', dict())


def get_pod_agent_payload(pod_template_spec):
    return get_pod_spec(pod_template_spec) \
        .get('pod_agent_payload', dict())


def get_pod_agent_spec(pod_template_spec):
    return get_pod_agent_payload(pod_template_spec) \
        .get('spec', dict())


def get_boxes(pod_template_spec):
    return get_pod_agent_spec(pod_template_spec) \
        .get('boxes', list())


def get_workloads(pod_template_spec):
    return get_pod_agent_spec(pod_template_spec) \
        .get('workloads', list())


def get_resources(pod_template_spec):
    return get_pod_agent_spec(pod_template_spec) \
        .get('resources', dict())


def get_statis_resources(pod_template_spec):
    return get_resources(pod_template_spec) \
        .get('static_resources', list())


def find_by_id(entities,
               expected_id,
               id_field: str = 'id'):
    filtered = list(filter(lambda entity: expected_id == entity.get(id_field, ''), entities))
    return dict() if 0 == len(filtered) else filtered[0]
