from abc import ABC, abstractmethod

import yt.yson as yson
from yp_proto.yp.client.api.proto import object_service_pb2


class YpObjectFilter(ABC):
    @abstractmethod
    def __call__(self,
                 yp_client_stub,
                 object,
                 object_type,
                 **kwargs):
        pass

    @property
    @abstractmethod
    def selectors(self):
        return []


class PodTemplateSpecFilter(YpObjectFilter):
    POD_TEMPLATE_SPEC_SELECTOR = '/spec/pod_template_spec'

    def __call__(self,
                 yp_client_stub,
                 object,
                 object_type,
                 **kwargs):
        pod_template_spec = object[PodTemplateSpecFilter.POD_TEMPLATE_SPEC_SELECTOR]

        if not isinstance(pod_template_spec, dict):
            return False

        return self.check_pod_template_spec(pod_template_spec)

    @property
    def selectors(self):
        return [PodTemplateSpecFilter.POD_TEMPLATE_SPEC_SELECTOR]

    @abstractmethod
    def check_pod_template_spec(self, pod_template_spec):
        pass

    @staticmethod
    def get_pod_template_spec(yp_client_stub, object_id, object_type):
        req = object_service_pb2.TReqGetObject()
        req.object_type = object_type
        req.object_id = object_id
        req.selector.paths.append("/spec/pod_template_spec")

        resp = yp_client_stub.GetObject(req)

        return yson.loads(resp.result.values[0])


class AcceptAnySpecFilter(PodTemplateSpecFilter):
    def check_pod_template_spec(self, pod_template_spec):
        return True
