from infra.deploy.dri.logbroker.logbroker_filter import PushAgentWorkloadFilter


class CustomDestroyPolicyFilter(PushAgentWorkloadFilter):
    DEFAULT_DESTROY_POLICY_MAX_TRIES = 3
    DEFAULT_DESTROY_POLICY_RESTART_PERIOD_MS = 10000

    def check_push_agent_workload(self, push_agent_workload):
        destroy_policy = push_agent_workload.get('destroy_policy', dict())

        max_tries = destroy_policy\
            .get('max_tries', CustomDestroyPolicyFilter.DEFAULT_DESTROY_POLICY_MAX_TRIES)

        restart_period_ms = destroy_policy\
            .get('container', dict()) \
            .get('time_limit', dict()) \
            .get('min_restart_period_ms', CustomDestroyPolicyFilter.DEFAULT_DESTROY_POLICY_RESTART_PERIOD_MS)

        return max_tries != CustomDestroyPolicyFilter.DEFAULT_DESTROY_POLICY_MAX_TRIES \
               or restart_period_ms != CustomDestroyPolicyFilter.DEFAULT_DESTROY_POLICY_RESTART_PERIOD_MS
