from infra.deploy.dri.lib.argument_parser_builder import ArgumentParserBuilder
from infra.deploy.dri.lib.stages_getter import StagesGetter
import infra.deploy.dri.lib.io_utils as io_utils
from infra.deploy.dri.logbroker.custom_destroy_policy_filter import CustomDestroyPolicyFilter


def parse_arguments(description: str):
    parser = ArgumentParserBuilder(description) \
        .with_clusters() \
        .with_yp_token() \
        .build()

    return parser.parse_args()


if __name__ == "__main__":
    arguments = parse_arguments("Get stages with custom destroy policy")
    stages_getter = StagesGetter(token=arguments.token, object_filter=CustomDestroyPolicyFilter())

    stages_getter.process_all_clusters(clusters=arguments.clusters)

    io_utils.press_enter_prompt()
