from infra.deploy.dri.lib.argument_parser_builder import ArgumentParserBuilder
from infra.deploy.dri.lib.stages_getter import StagesGetter
import infra.deploy.dri.lib.io_utils as io_utils
from infra.deploy.dri.logbroker.custom_topic_filter import CustomTopicUrlFilter


def parse_arguments(description: str):
    parser = ArgumentParserBuilder(description) \
        .with_clusters() \
        .with_yp_token() \
        .build()

    return parser.parse_args()


if __name__ == "__main__":
    arguments = parse_arguments("Get stages with custom topic")
    stages_getter = StagesGetter(token=arguments.token, object_filter=CustomTopicUrlFilter())

    stages_getter.process_all_clusters(clusters=arguments.clusters)

    io_utils.press_enter_prompt()
