from abc import abstractmethod

from infra.deploy.dri.lib.yp_object_filter import PodTemplateSpecFilter
import infra.deploy.dri.lib.spec_utils as spec_utils


class LogbrokerFilter(PodTemplateSpecFilter):
    def check_pod_template_spec(self, pod_template_spec):
        logs_enabled = LogbrokerFilter.get_deploy_logs_labels(pod_template_spec) \
            .get("delivery_enabled", False)

        if not logs_enabled:
            return False

        return self.check_pod_template_spec_with_logs(pod_template_spec)

    @abstractmethod
    def check_pod_template_spec_with_logs(self,
                                          pod_template_spec):
        pass

    @staticmethod
    def get_deploy_logs_labels(pod_template_spec):
        return spec_utils.get_deploy_labels(pod_template_spec) \
            .get('logs', dict())


class PushAgentWorkloadFilter(LogbrokerFilter):
    def check_pod_template_spec_with_logs(self,
                                          pod_template_spec):
        workloads = spec_utils.get_workloads(pod_template_spec)
        push_agent_workload = spec_utils.find_by_id(workloads, 'logbroker_push_agent_workload')

        return self.check_push_agent_workload(push_agent_workload)

    @abstractmethod
    def check_push_agent_workload(self, push_agent_workload):
        pass
