from infra.deploy.dri.logbroker.unified_agent_config_filter import UnifiedAgentConfigUrlFilter


class ThrottlingUrlFilter(UnifiedAgentConfigUrlFilter):
    __slots__ = ['expected_rate', 'expected_messages']

    def __init__(self,
                 expected_rate: str = None,
                 expected_messages: int = None):
        self.expected_rate = expected_rate
        self.expected_messages = expected_messages

    def check_unified_agent_config_url(self, unified_agent_config_url):
        expected_rate_field = 'stage_rate_limit: \"{}\"'.format(self.expected_rate)
        expected_messages_field = 'stage_messages_rate_limit: {}'.format(self.expected_messages)

        expected_rate_found = expected_rate_field in unified_agent_config_url
        expected_messages_found = expected_messages_field in unified_agent_config_url

        return expected_rate_found and expected_messages_found
