from infra.deploy.dri.lib.argument_parser_builder import ArgumentParserBuilder
from infra.deploy.dri.lib.stages_getter import StagesGetter
import infra.deploy.dri.lib.io_utils as io_utils
from infra.deploy.dri.logbroker.throttling_filter import ThrottlingUrlFilter


def parse_arguments(description: str):
    parser = ArgumentParserBuilder(description) \
        .with_clusters() \
        .with_yp_token() \
        .build()

    parser.add_argument(
        "--rate",
        dest="rate",
        type=str,
        required=False,
        help="Throttling rate limit (example: 15mb)"
    )

    parser.add_argument(
        "--messages",
        dest="messages",
        type=int,
        required=False,
        help="Throttling messages rate limit (example: 20000)"
    )

    return parser.parse_args()


def main():
    arguments = parse_arguments("Get stages with specified throttling")

    rate = arguments.rate
    messages = arguments.messages

    if rate is None and messages is None:
        print('At least one of rate or messages is required')
        return

    stages_getter = StagesGetter(
        token=arguments.token,
        object_filter=ThrottlingUrlFilter(
            expected_rate=rate,
            expected_messages=messages
        )
    )

    stages_getter.process_all_clusters(clusters=arguments.clusters)

    io_utils.press_enter_prompt()

if __name__ == "__main__":
    main()
