#include <infra/deploy/horizontal_pod_autoscaler_controller/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"horizontal_pod_autoscaler_controller"});

    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NHorizontalPodAutoscalerController::RunDaemon,
        "Run HorizontalPodAutoscalerController daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print HorizontalPodAutoscalerController log."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return -1;
    }

}
