#include "main.h"

#include <infra/deploy/horizontal_pod_autoscaler_controller/libs/config/config.pb.h>
#include <infra/deploy/horizontal_pod_autoscaler_controller/libs/manager_factory/hpa_manager.h>

#include <infra/libs/controller/daemon/main.h>
#include <infra/libs/logger/logger.h>

namespace NInfra::NHorizontalPodAutoscalerController {

int RunDaemon(int argc, const char* argv[]) {
    const THpaConfig config = NProtoConfig::GetOpt<THpaConfig>(argc, argv, "/proto_config/config.json");

    NClients::TGolovanClientPtr golovanClient = new NClients::TGolovanClient(new NHttpExecuter::THttpExecuter(config.GetGolovan().GetHttp()));

    NClients::TSolomonClientPtr solomonClient = new NClients::TSolomonClient(new NHttpExecuter::THttpExecuter(config.GetSolomon().GetHttp()));

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());

    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();

    NUpdatableProtoConfig::TConfigHolderPtr<THpaConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    return RunDaemon(
        configHolder->Accessor<NController::TControllerConfig>("Controller")
        , new THorizontalPodAutoscalerManagerFactory(
            golovanClient
            , solomonClient
            , config.GetGeoLabel()
            , shardsFactory.GetShard(0)
        )
    );
}

} // namespace NInfra::NHorizontalPodAutoscalerController
