#pragma once

#include <infra/libs/clients/golovan/golovan_client.h>
#include <infra/libs/clients/solomon/solomon_client.h>

#include <infra/libs/controller/object_manager/object_manager.h>

#include <yp/cpp/yp/data_model.h>

namespace NInfra::NHorizontalPodAutoscalerController {

class THorizontalPodAutoscalerManager : public NController::ISingleClusterObjectManager {
public:
    THorizontalPodAutoscalerManager(
        const NYP::NClient::THorizontalPodAutoscaler& horizontalPodAutoscaler
        , NClients::TGolovanClientPtr golovanClient
        , NClients::TSolomonClientPtr solomonClient
        , const TString& geoTag
        , ui64 ypTimestamp
    )
        : HorizontalPodAutoscaler_(horizontalPodAutoscaler)
        , GolovanClient_(golovanClient)
        , SolomonClient_(solomonClient)
        , GeoTag_(geoTag)
        , YpTimestamp_(ypTimestamp)
    {}

    virtual TString GetObjectId() const override final;

    virtual TVector<TSelectArgument>  GetDependentObjectsSelectArguments() const override final;

    virtual void GenerateYpUpdates(
        const ISingleClusterObjectManager::TDependentObjects& dependentObjects
        , TVector<ISingleClusterObjectManager::TRequest>& requests
        , TLogFramePtr frame
    ) const override final;

private:
    NYP::NClient::TReplicaSet FillReplicaSet(
        const NController::TSelectorResultPtr& selectResult
    ) const;

    bool HpaValidate(
        const TInstant& nowTime
        , bool isDryRunMode
        , TLogFramePtr frame
        , TDuration& upscaleDelay
        , TDuration& downscaleDelay
        , NYP::NClient::NApi::NProto::THorizontalPodAutoscalerStatus& hpaStatus
    ) const;

    double GetCurrentMetric(
        const NYP::NClient::TReplicaSet& replicaSet
        , NInfra::TLogFramePtr frame
    ) const;

    std::pair<double, double> GetBounds() const;

    void SetIntGaugeSensor(const TString& nameSuffix, ui64 value) const;

    void SetGaugeSensor(const TString& nameSuffix, double value) const;

private:
    inline static const TSensorGroup HORIZONTAL_POD_AUTOSCALER_SENSOR_GROUP = TSensorGroup("hpa_ctl");

    const NYP::NClient::THorizontalPodAutoscaler HorizontalPodAutoscaler_;

    NClients::TGolovanClientPtr GolovanClient_;

    NClients::TSolomonClientPtr SolomonClient_;

    const TString GeoTag_;

    const ui64 YpTimestamp_;
};

class THorizontalPodAutoscalerManagerFactory : public NController::ISingleClusterObjectManagerFactory {
public:
    THorizontalPodAutoscalerManagerFactory(
        NClients::TGolovanClientPtr golovanClient
        , NClients::TSolomonClientPtr solomonClient
        , const TString& geoTag
        , NController::TShardPtr shard
    )
        : ISingleClusterObjectManagerFactory("hpa_manager_factory", shard)
        , GolovanClient_(golovanClient)
        , SolomonClient_(solomonClient)
        , GeoTag_(geoTag)
    {}

    virtual NController::ISingleClusterObjectManager::TSelectArgument GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;

    virtual TExpected<NController::TSingleClusterObjectManagerPtr, TValidationError> GetSingleClusterObjectManager(
        const NController::TSelectorResultPtr& selectorResultPtr
        , TLogFramePtr frame
    ) const override final;

private:
    NClients::TGolovanClientPtr GolovanClient_;

    NClients::TSolomonClientPtr SolomonClient_;

    const TString GeoTag_;
};

} // namespace NInfra::NHorizontalPodAutoscalerController
