#pragma once

#include <infra/deploy/horizontal_pod_autoscaler_controller/libs/config/config.pb.h>
#include <infra/deploy/horizontal_pod_autoscaler_controller/libs/manager_factory/hpa_manager.h>

#include <infra/libs/clients/http_executer/http_executer_mock.h>
#include <infra/libs/controller/standalone_controller/standalone_controller.h>


namespace NInfra::NHorizontalPodAutoscalerController {

NController::TObjectManagersFactoryPtr CreateFactory(TStringBuf configJson, TString golovanResponse) {
    auto config = NProtoConfig::ParseConfigFromJson<THpaConfig>(configJson);

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());

    return new THorizontalPodAutoscalerManagerFactory(
        new NClients::TGolovanClient(new NHttpExecuter::THttpExecuterMock(golovanResponse))
        , new NClients::TSolomonClient(new NHttpExecuter::THttpExecuterMock(TString("{\"scalar\":42.0}")))
        , "cluster" /* geoTag */
        , shardsFactory.GetShard(0)
    );
}

class THorizontalPodAutoscalerStandaloneController: public NInfra::NController::TStandaloneController {
public:
    THorizontalPodAutoscalerStandaloneController(TStringBuf config, TString golovanResponse)
        : NInfra::NController::TStandaloneController(
            NProtoConfig::ParseConfigFromJson<THpaConfig>(config).GetController()
            , CreateFactory(config, golovanResponse)
        )
    {
    }
};

} // namespace NInfra::NHorizontalPodAutoscalerController
