from infra.deploy.tools.yd_migrate.lib.feature_coverage import calc_over_dumped
from infra.deploy.tools.yd_migrate.lib.migrator_nanny import NannyMigrator
from infra.deploy.tools.yd_migrate.lib.nanny_api import NannyApi

import library.python.init_log

import argparse
import json
import logging


def calc_over_dumped_args(args):
    calc_over_dumped(NannyMigrator, args.dump_file, args.with_prefix_implementation_result)


def dump_nanny_services(args):
    custom_service_list = []
    if args.custom_service_list:
        with open(args.custom_service_list) as f:
            content = f.readlines()
        # you may also want to remove whitespace characters like `\n` at the end of each line
        custom_service_list = [x.strip() for x in content]

    api = NannyApi(args.nanny_token)
    services = api.list_services()
    dumps = {}
    for it in services:
        if custom_service_list:
            if it['_id'] not in custom_service_list:
                continue
            logging.info('found service %s', it['_id'])
        else:
            if it['_id'].startswith('bootstrap'):
                logging.warning('skip samogon %s', it['_id'])
                continue
            if it['info_attrs']['content'].get('type') == 'AWACS_BALANCER' or it['info_attrs']['content']['category'].startswith('/balancer/'):
                logging.warning('skip awacs balancer %s', it['_id'])
                continue
            if it['info_attrs']['content']['category'].startswith('/sepe/yappy/yp_slots/') or it['info_attrs']['content']['category'].startswith('/yappy/slots/'):
                logging.warning('skip yappy slot %s', it['_id'])
                continue
            if it['info_attrs']['content']['category'].startswith('/yt/clusters/'):
                logging.warning('skip yt cluster %s', it['_id'])
                continue
            if it['info_attrs']['content']['category'].startswith('/market/multitesting/'):
                logging.warning('skip TSUM multitesting %s', it['_id'])
                continue
            if it['info_attrs']['content']['category'].startswith('/saas/cloud/'):
                logging.warning('skip SAAS cloud %s', it['_id'])
                continue
            if it['info_attrs']['content']['category'].startswith('/sandbox/dev'):
                logging.warning('skip sandbox dev machines cloud %s', it['_id'])
                continue
            if it['info_attrs']['content']['category'].startswith('/voicetech/production/yaldi'):
                logging.warning('skip yaldi autogenerated service %s', it['_id'])
                continue

        if it.get('target_state') and it['target_state']['content']['is_enabled']:
            dumps[it['_id']] = it
    logging.info('total services: %s', len(dumps))
    with open(args.dump_file, 'w') as f:
        f.write(json.dumps(dumps))

logger = logging.getLogger(__name__)
library.python.init_log.init_log(level='DEBUG')

parser = argparse.ArgumentParser(description='Calc coverage of nanny environment features.')
parser.add_argument('-d', '--dump-file', type=str, default='dump.json')
subparsers = parser.add_subparsers()

parse_dump = subparsers.add_parser('dump', help='Dump nanny environments to dump.json.')
parse_dump.add_argument('nanny_token', type=str)
parse_dump.add_argument('-c', '--custom-service-list', type=str)
parse_dump.set_defaults(func=dump_nanny_services)

parse_calc = subparsers.add_parser('calc', help='Calc coverage over dump.json.')
parse_calc.add_argument('--with-prefix-implementation-result', type=int, default=50, help='For first N prefixes of top unimplemented features: calc result if prefix would be implemented.')
parse_calc.set_defaults(func=calc_over_dumped_args)

args = parser.parse_args()
args.func(args)
