import collections
import json
import logging
import operator


def calc_over_dumped(migrator_class, dump_file, with_prefix_implementation_result):
    specs = []
    with open(dump_file, 'r') as f:
        data = f.read()
        specs = json.loads(data)

    # calc
    ready_for_migrate = []
    errors_to_env_map = {}
    env_to_errors_map = {}
    for i in range(len(specs)):
        spec_key = specs.keys()[i]
        spec = specs[spec_key]
        logging.debug('progress: %s / %s : %s', i, len(specs), spec_key)

        try:
            migrator_class(spec, stage_id='', raise_on_error=True, mock_clients=True).migrate()
            ready_for_migrate.append(spec_key)
        except migrator_class.NotImplementedExceptionList as el:
            ignored = set()  # append some keyset to this set manually for coverage research
            key_set = ignored.copy()

            for e in el.errors:
                key = '/'.join(['X' if isinstance(x, int) else str(x) for x in e.path])
                if key not in key_set:
                    errors_to_env_map.setdefault(key, []).append((spec_key, unicode(e)))
                    env_to_errors_map.setdefault(spec_key, set()).add(key)
                key_set.add(key)

            if key_set == ignored:
                ready_for_migrate.append(spec_key)

    errors_map_cnt = {k: len(errors_to_env_map[k]) for k in errors_to_env_map}
    errors_map_cnt = collections.OrderedDict(sorted(errors_map_cnt.items(), key=operator.itemgetter(1), reverse=True))

    # post calc
    ready_on_prefix_implementation = []
    for i in range(len(errors_map_cnt)):
        prefix = set(errors_map_cnt.keys()[:i + 1])
        cur_ready_for_migrate = list(ready_for_migrate)
        for env, err_set in env_to_errors_map.iteritems():
            err_set -= prefix
            if not err_set:
                cur_ready_for_migrate.append(env)
        x = len(cur_ready_for_migrate)
        feature = errors_map_cnt.keys()[i]
        ready_on_prefix_implementation.append('%3d %5d %5d %s' % (100 * x / len(specs), x, errors_map_cnt[feature], feature))
    logging.debug('ready_for_migrate: %s', json.dumps(ready_for_migrate))
    logging.info('total specs: %s', len(specs))
    logging.info('ready_for_migrate: %s (%d%%)', len(ready_for_migrate), (100 * len(ready_for_migrate)) / len(specs))
    logging.info('%     : percentage of services, that would be ready for migration after implementation of this feature, and all on top of it')
    logging.info('CNT   : number of services, that would be ready for migration after implementation of this feature, and all on top of it')
    logging.info('USAGE : number of services, that use this feature')
    logging.info('ready_on_prefix_implementation: %s', '    \n'.join(['', '  %   CNT USAGE FEATURE'] + ready_on_prefix_implementation))


def print_covered_enviroments(migrator_class, dump_file):
    def get_env_list(env_list):
        res = {}
        for env in env_list:
            res[env] = {}
        return res

    def get_application_list(application_list, covered_list, not_covered_list):
        res = {}
        for application in application_list:
            res[application] = {}
            res[application]["covered"] = covered_list[application]
            res[application]["not_covered"] = not_covered_list[application]
            res[application]["enviroments"] = get_env_list(application_list[application])
        return collections.OrderedDict(
            sorted(
                res.items(),
                key=lambda t: float(t[1]["not_covered"]) / (t[1]["not_covered"] + t[1]["covered"])
            )
        )

    def get_project_list(project_list, covered_list, not_covered_list):
        res = {}
        for project in project_list:
            res[project] = {}
            res[project]["covered"] = sum(covered_list[project].values())
            res[project]["not_covered"] = sum(not_covered_list[project].values())
            res[project]["applications"] = get_application_list(project_list[project], covered_list[project], not_covered_list[project])
        return collections.OrderedDict(
            sorted(
                res.items(),
                key=lambda t: float(t[1]["not_covered"]) / (t[1]["not_covered"] + t[1]["covered"])
            )
        )

    specs = []
    with open(dump_file, 'r') as f:
        data = f.read()
        specs = json.loads(data)

    ready_for_migrate = []
    project_list = {}
    covered_list = {}
    not_covered_list = {}
    # calc
    for i in range(len(specs)):
        logging.debug('progress: %s / %s', i, len(specs))
        spec_key = specs.keys()[i]
        spec = specs[spec_key]

        project, env, application = spec_key.split('.')
        try:
            migrator_class(spec, spec_key, raise_on_error=True).migrate()
            ready_for_migrate.append(spec_key)
            not_coverage = 0
        except migrator_class.NotImplementedExceptionList as el:
            not_coverage = len(el.errors)

        if project not in project_list:
            project_list[project] = {}
            covered_list[project] = {}
            not_covered_list[project] = {}
        if env not in project_list[project]:
            project_list[project][env] = []
            covered_list[project][env] = 0
            not_covered_list[project][env] = 0
        if not_coverage:
            not_covered_list[project][env] += 1
        else:
            covered_list[project][env] += 1
            project_list[project][env].append(application)

    logging.info(json.dumps(get_project_list(project_list, covered_list, not_covered_list), indent=2))

    ready_for_migrate.sort()
    logging.info(json.dumps(ready_for_migrate, indent=2))
