import requests
import time


class NannyApi(object):
    SERVICES_API = 'http://nanny.yandex-team.ru/v2/services'

    def __init__(self, token):
        self.session = requests.Session()
        self.session.headers.update({
            'Authorization': 'OAuth {}'.format(token),
        })

    def _do_req(self, method, path, json=None, data=None):
        method = getattr(self.session, method)
        r = method(path, json=json, data=data)
        if not r.ok:
            r.raise_for_status()
        return r

    def list_services(self):
        skip = 0
        while True:
            url = '{}/?limit=100&skip={}'.format(self.SERVICES_API, skip)
            r = self._do_req('get', url)
            current = r.json()['result']
            if not current:
                break
            for it in current:
                yield it
            skip += len(current)
            time.sleep(0.05)  # 20 RPS

    def get_service_spec(self, service_id):
        url = '{}/{}'.format(self.SERVICES_API, service_id)
        res = self._do_req('get', url)
        return res.json()
