import requests


class QloudApi(object):
    API_URL = 'https://{contour}.yandex-team.ru/api'

    def __init__(self, token, contour):
        self.API_URL = self.API_URL.format(contour=contour)
        self.session = requests.Session()
        self.session.headers.update({
            'Authorization': 'OAuth {}'.format(token),
        })

    def _do_req(self, method, path, json=None, data=None):
        method = getattr(self.session, method)
        r = method(path, json=json, data=data)
        if not r.ok:
            r.raise_for_status()
        return r

    def _make_proper_str(self, s):
        return s.replace('*', '')

    def _obj_id(self, project, app, env):
        return self._make_proper_str('%s.%s.%s' % (project, app, env))

    def get_project_tree(self):
        url = '{}/project-tree'.format(self.API_URL)
        r = self._do_req('get', url)
        return r.json()

    def get_environment_spec(self, project, app, env):
        domains_url = '{}/v1/domains/{}'.format(self.API_URL, self._obj_id(project, app, env))
        domains = self._do_req('get', domains_url)
        dump_url = '{}/v1/environment/dump/{}'.format(self.API_URL, self._obj_id(project, app, env))
        dump = self._do_req('get', dump_url)
        stable_url = '{}/v1/environment/stable/{}'.format(self.API_URL, self._obj_id(project, app, env))
        stable = self._do_req('get', stable_url)
        return {
            'domains': domains.json(),
            'dump': dump.json(),
            'stable': stable.json(),
        }
