import urllib2
import requests
import json
from collections import defaultdict
import re

PROD_HOST = 'yasm.yandex-team.ru'
PRESTABLE_HOST = 'yasmpre.yandex-team.ru'

FIND_URL_TEMPLATE = '{protocol}://{host}/srvambry/raw/find?{qs}'

OUTPUT_TEMPLATES = {'edit': '{protocol}://{host}/ambry/?id={name}',
                    'yasm': 'https://yasm.yandex-team.ru/panel/{name}',
                    'golovan': 'https://yasm.yandex-team.ru/panel/?id={name}',
                    'name': '{name}'}


def match_itype_tag_query(itype, tag):
    matching = {
        '$elemMatch': {
            'signals': {
                '$elemMatch': {
                    '$and': [
                        {
                            'tag': {
                                '$regex': itype
                            }
                        },
                        {
                            'tag': {
                                '$regex': tag
                            }
                        },
                    ]
                }
            }
        }
    }
    return {
        '$or': [
            {
                'value.charts': matching
            },
            {
                'charts': matching
            },
        ]
    }


def find_itype_tag_panels(itype, tag, count_only=False, host=PROD_HOST, protocol='https', limit=None):
    """
    :param sig_pattern: str, representing regexp
    :param count_only: bool, return only count of panels
    :param host: str, ambry host
    :param limit: int, number of entries to return (count_only mode doesn't use it)
    :return: list of panels, where this signals is found
    """
    data = json.dumps(match_itype_tag_query(itype, tag))
    if count_only:
        qs = 'count=true'
    elif limit:
        qs = 'limit=%d' % limit
    else:
        qs = ''
    url = FIND_URL_TEMPLATE.format(protocol=protocol, host=host, qs=qs)
    return json.load(urllib2.urlopen(url, data))


def group_panels_by_user(panels):
    """
    :param panels: list of panels
    :return: dict {'user': ['panel_name', ...], ...}
    """
    grouped = defaultdict(list)
    for panel in panels:
        user = panel['user']
        panel_name = panel.get('key', None) or panel['_id']
        grouped[user].append(panel_name)
    return grouped


def get_fronts():
    r = requests.get('https://yasm.yandex-team.ru/metainfo/hosts/?itype=rtfront&ctype=prod')
    if r.status_code != 200:
        return []
    resp = r.json()
    status = resp.get('status', 'error')
    if status != 'ok':
        return []
    response = resp.get('response', {})
    front_list = [host['name'] for host in response.get('result', [])]

    r = requests.get('https://yasm.yandex-team.ru/metainfo/hosts/?itype=yasmafront&ctype=prod')
    if r.status_code != 200:
        return []
    resp = r.json()
    status = resp.get('status', 'error')
    if status != 'ok':
        return []
    response = resp.get('response', {})
    afront_list = [host['name'] for host in response.get('result', [])]
    return front_list + afront_list


def get_front_subs(front, port):
    try:
        front_addr = 'http://%s:%s/subs' % (front, port)
        r = requests.get(front_addr)
        if r.status_code != 200:
            return set()
        response = r.json()
        if response:
            status = response.get('status', 'error')
            if status != 'ok':
                return set()
            response = response.get('response', {})
        else:
            return set()

        subs = set()
        for group, group_subs in response.iteritems():
            # subs |= set([':'.join(s.split(':')[:-1]) for s in group_subs])
            subs |= set(['{}:{}'.format(group, sub) for sub in group_subs])

        subs |= set(response.keys())
        return subs
    except:
        return set()


def get_full_subs():
    fronts = get_fronts()
    subs = set()
    for front in fronts:
        subs |= get_front_subs(front, 13905)
    return subs


def find_signal_in_subs(signal):
    full_subs = get_full_subs()
    subs = []
    for sub in full_subs:
        matchObj = re.findall(signal, sub)
        if matchObj:
            subs.append(sub)
    return subs


def find_signal_in_panel(panel, signal, tag=None):
    charts = panel.get('charts', None)
    if charts is not None:
        if type(charts) is dict:
            charts = charts.get('charts', [])
    else:
        charts = panel.get('value', [])
        if type(charts) is dict:
            charts = charts.get('charts', [])
    if type(charts) is not list:
        return False
    for chart in charts:
        if type(chart) is not dict:
            continue
        signals = chart.get('signals', [])
        if type(signals) is not list:
            continue
        for s in signals:
            if type(s) is dict:
                if signal in s.get('name', ''):
                    return True
                if tag is not None:
                    if signal in s.get('tag', ''):
                        return True
            else:
                if signal in s:
                    return True
    return False


def find_alert_in_panel(panel, prefix):
    charts = panel.get('charts', None)
    if charts is not None:
        if type(charts) is dict:
            charts = charts.get('charts', [])
    else:
        charts = panel.get('value', [])
        if type(charts) is dict:
            charts = charts.get('charts', [])
    if type(charts) is not list:
        return False
    for chart in charts:
        if type(chart) is not dict:
            continue
        if chart.get('type', '') != 'alert':
            continue
        if prefix in chart.get('name', ''):
            return True
    return False


def find_signal_in_panels(signal, tag=None):
    full_panels = None
    with open('data/all.json') as h:
        full_panels = json.load(h).get('result', [])

    if full_panels is None:
        return []
    panels = []
    for panel in full_panels:
        if find_signal_in_panel(panel, signal, tag):
            panels.append(panel)
    return panels


def load_templates():
    # 'https://yasm.yandex-team.ru/srvambry/tmpl/panels/list?fields=key,content'
    r = requests.get('https://yasm.yandex-team.ru/srvambry/tmpl/panels/list?fields=key,owners,content')
    if r.status_code != 200:
        return []

    response = r.json()
    if response['status'] != 'ok':
        return []

    return response.get('response', [])


def load_alerts():
    r = requests.get('https://yasm.yandex-team.ru/srvambry/alerts/list')
    if r.status_code == 200:
        response = r.json()
        if response['status'] != 'ok':
            return []  # error
        response = response.get('response', {})
        raw_alerts = response.get('result', [])
        return raw_alerts
    return None


def find_signal_in_templates_simple(signal):
    templates = load_templates()
    grouped_panels = defaultdict(list)

    panels = []
    for panel in templates:
        content = panel.get('content', '')
        if content.find(signal) > 0:
            for owner in panel['owners']:
                grouped_panels[owner].append(panel['key'])
            panels.append((panel['key'], panel['owners']))
    return grouped_panels


def find_signal_in_templates(signal):
    templates = load_templates()
    grouped_panels = defaultdict(list)

    panels = []
    for panel in templates:
        matchObj = re.findall(signal, panel.get('content', ''))
        if matchObj:
            for owner in panel.get('owners', [None]):
                grouped_panels[owner].append(panel['key'])
            panels.append((panel['key'], panel.get('owners', [None])))
    return grouped_panels


def find_tags_in_templates(itype, prj, templates=[]):
    grouped_panels = defaultdict(list)

    panels = []
    for panel in templates:
        matchObj = re.findall('itype={}'.format(itype), panel.get('content', '')) and re.findall('prj={}'.format(prj), panel.get('content', ''))
        if matchObj:
            for owner in panel.get('owners', [None]):
                grouped_panels[owner].append(panel['key'])
            panels.append((panel['key'], panel.get('owners', [None])))
    return grouped_panels


def find_alerts_by_prj(itype=None, prj=None, raw_alerts=[]):
    alerts = []
    for alert in raw_alerts:
        alert_name = alert['name']
        alert_itype = alert['tags'].get('itype', '')
        alert_prjs = alert['tags'].get('prj', [])
        if type(alert_itype) is not list:
            alert_itype = [alert_itype]
        if itype is not None:
            if itype not in alert_itype:
                continue
        if type(alert_prjs) is not list:
            if prj == alert_prjs:
                alerts.append((alert_name, alert['signal']))
        else:
            if prj in alert_prjs:
                alerts.append((alert_name, alert['signal']))
    return alerts


def find_qloud_project_signals_usage(itype=None, prj=None, templates=None, alerts=None):
    panels = group_panels_by_user(find_itype_tag_panels(itype, 'prj={}'.format(prj)).get('result', []))
    templates = find_tags_in_templates(itype, prj, templates)
    alerts = find_alerts_by_prj(itype=itype, prj=prj, raw_alerts=alerts)

    total_count = 0
    panel_names = set()
    template_names = set()

    for a, p in panels.iteritems():
        total_count += len(p)

    for a, ps in panels.iteritems():
        panel_names |= set(ps)

    for a, ps in templates.iteritems():
        template_names |= set(ps)

    res = ""
    if len(alerts):
        res += ("alerts %s\n" % alerts)
    if len(panel_names):
        res += ("panels %s\n" % panel_names)
    if len(template_names):
        res += ("templates %s\n" % template_names)
    return res


def qloud_signals_helper(prj):
    templates = load_templates()
    alerts = load_alerts()
    return find_qloud_project_signals_usage(
        itype='qloud',
        prj=prj,
        templates=templates,
        alerts=alerts
    )
